/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.utils.uuid;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;

public class MojangWebAPI {
    public static final String UUID_NAME_LOOKUP_ENDPOINT = "https://api.mojang.com/profiles/minecraft";
    public static final String NAME_DATA_LOOKUP_ENDPOINT = "https://sessionserver.mojang.com/session/minecraft/profile/";
    public static final String HAS_PAID_ENDPOINT = "https://minecraft.net/haspaid.jsp?user=";
    public static final String NAME_PROFILE_AT_ENDPOINT = "https://api.mojang.com/users/profiles/minecraft/";
    public static final String UUID_HISTORY_ENDPOINT = "https://api.mojang.com/user/profiles/<uuid>/names";
    public static final int MAX_QUERIES_PER_REQUEST = 100;

    public static Map<String, UUID> lookupUUIDS(List<String> names) throws Exception {
        HashMap<String, UUID> map = new HashMap<String, UUID>();
        for (int offset = 0; offset < names.size(); offset += 100) {
            map.putAll(MojangWebAPI.lookupUUIDLimited(names.subList(offset, Math.min(names.size(), offset + 100))));
        }
        return map;
    }

    public static Map<String, UUID> lookupUUIDLimited(List<String> names) throws Exception {
        if (names.size() > 100) {
            throw new IllegalArgumentException("Can only process 100 names at a time!");
        }
        HashMap<String, UUID> uuidMap = new HashMap<String, UUID>();
        URL url = new URL(UUID_NAME_LOOKUP_ENDPOINT);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        OutputStream body = connection.getOutputStream();
        ArrayList<String> array = new ArrayList<String>();
        array.addAll(names);
        body.write(new Gson().toJson(array).getBytes());
        body.flush();
        body.close();
        List profiles = (List)new Gson().fromJson(new JsonReader((Reader)new InputStreamReader(connection.getInputStream())), new TypeToken<List<ProfileEntry>>(){}.getType());
        for (ProfileEntry o : profiles) {
            uuidMap.put(o.name, o.getUUID());
        }
        return uuidMap;
    }

    public static boolean hasPaid(String name) throws Exception {
        URL url = new URL(HAS_PAID_ENDPOINT + name);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(false);
        connection.connect();
        connection.getResponseCode();
        Scanner scan = new Scanner(connection.getInputStream());
        String s = scan.next();
        scan.close();
        return Boolean.parseBoolean(s);
    }

    public static UUID lookupUuidByNameAt(String name, long timestamp) throws Exception {
        URL url = new URL(NAME_PROFILE_AT_ENDPOINT + name + (timestamp == -1L ? "" : "?at=" + timestamp));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(false);
        connection.connect();
        connection.getResponseCode();
        ProfileEntry profile = (ProfileEntry)new Gson().fromJson(new JsonReader((Reader)new InputStreamReader(connection.getInputStream())), ProfileEntry.class);
        if (profile.error.length() > 0) {
            return null;
        }
        return profile.getUUID();
    }

    public static List<String> getProfileAliases(UUID uuid) throws Exception {
        ArrayList aliases = new ArrayList();
        URL url = new URL(UUID_HISTORY_ENDPOINT.replace("<uuid>", uuid.toString().replaceAll("-", "")));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(false);
        connection.connect();
        connection.getResponseCode();
        return (List)new Gson().fromJson(new JsonReader((Reader)new InputStreamReader(connection.getInputStream())), new TypeToken<List<String>>(){}.getType());
    }

    public static List<String> getKnownAliases(String name, long timestamp) throws Exception {
        return MojangWebAPI.getProfileAliases(MojangWebAPI.lookupUuidByNameAt(name, timestamp));
    }

    public static List<String> getKnownAliases(String name) throws Exception {
        return MojangWebAPI.getProfileAliases(MojangWebAPI.lookupUuidByNameAt(name, -1L));
    }

    public static UUID expandUUID(String uuid) {
        return UUID.fromString(uuid.substring(0, 8) + "-" + uuid.substring(8, 12) + "-" + uuid.substring(12, 16) + "-" + uuid.substring(16, 20) + "-" + uuid.substring(20, 32));
    }

    public static String compactUUID(UUID uuid) {
        return uuid.toString().replaceAll("-", "");
    }

    public class ProfileEntry {
        public String error;
        public String id;
        public String name;

        public UUID getUUID() {
            return UUID.fromString(this.id.substring(0, 8) + "-" + this.id.substring(8, 12) + "-" + this.id.substring(12, 16) + "-" + this.id.substring(16, 20) + "-" + this.id.substring(20, 32));
        }
    }
}

