/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.utils.syringe;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public abstract class Injector<T, A extends Annotation> {
    private Class<A> annotation;

    public Injector(Class<A> annotation) {
        this.annotation = annotation;
    }

    public void inject(T object) {
        for (Field field : object.getClass().getDeclaredFields()) {
            A an = field.getAnnotation(this.annotation);
            if (an == null) continue;
            try {
                field.setAccessible(true);
                this.doInject(an, object, field);
                field.setAccessible(false);
            }
            catch (Exception exception) {
                this.onError(exception);
            }
        }
    }

    protected void onError(Exception e) {
    }

    protected abstract void doInject(A var1, T var2, Field var3) throws IllegalArgumentException, IllegalAccessException;
}

