/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.utils.signed;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarVerifier {
    public static void verify(JarFile jf, X509Certificate[] trustedCaCerts) throws IOException, CertificateException {
        Vector<JarEntry> entriesVec = new Vector<JarEntry>();
        Manifest man = jf.getManifest();
        if (man == null) {
            throw new SecurityException("The JAR is not signed");
        }
        byte[] buffer = new byte[8192];
        Enumeration<JarEntry> entries = jf.entries();
        while (entries.hasMoreElements()) {
            int n;
            JarEntry je = entries.nextElement();
            entriesVec.addElement(je);
            InputStream is = jf.getInputStream(je);
            while ((n = is.read(buffer, 0, buffer.length)) != -1) {
            }
            is.close();
        }
        jf.close();
        Enumeration e = entriesVec.elements();
        while (e.hasMoreElements()) {
            JarEntry je = (JarEntry)e.nextElement();
            if (je.isDirectory()) continue;
            Certificate[] certs = je.getCertificates();
            if (certs == null || certs.length == 0) {
                if (je.getName().startsWith("META-INF")) continue;
                throw new SecurityException("unsigned class files found.");
            }
            X509Certificate[] chainRoots = JarVerifier.getChainRoots(certs);
            boolean signedAsExpected = false;
            for (int i = 0; i < chainRoots.length; ++i) {
                if (!JarVerifier.isTrusted(chainRoots[i], trustedCaCerts)) continue;
                signedAsExpected = true;
                break;
            }
            if (signedAsExpected) continue;
            throw new SecurityException("The JAR is not signed by a trusted signer");
        }
    }

    public static boolean isTrusted(X509Certificate cert, X509Certificate[] trustedCaCerts) {
        int i;
        for (i = 0; i < trustedCaCerts.length; ++i) {
            if (!cert.getSubjectDN().equals(trustedCaCerts[i].getSubjectDN()) || !cert.equals(trustedCaCerts[i])) continue;
            return true;
        }
        for (i = 0; i < trustedCaCerts.length; ++i) {
            if (!cert.getIssuerDN().equals(trustedCaCerts[i].getSubjectDN())) continue;
            try {
                cert.verify(trustedCaCerts[i].getPublicKey());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static X509Certificate[] getChainRoots(Certificate[] certs) {
        Vector<X509Certificate> result = new Vector<X509Certificate>(3);
        for (int i = 0; i < certs.length - 1; ++i) {
            if (((X509Certificate)certs[i + 1]).getSubjectDN().equals(((X509Certificate)certs[i]).getIssuerDN())) continue;
            result.addElement((X509Certificate)certs[i]);
        }
        result.addElement((X509Certificate)certs[certs.length - 1]);
        Object[] ret = new X509Certificate[result.size()];
        result.copyInto(ret);
        return ret;
    }
}

