/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.utils.expressions;

import com.tehbeard.utils.expressions.UnresolvedFunctionException;
import com.tehbeard.utils.expressions.VariableProvider;
import com.tehbeard.utils.expressions.functions.FunctionProvider;
import java.util.ArrayList;
import java.util.Stack;

public class InFixExpressionV2 {
    private ArrayList<String> rules;

    public InFixExpressionV2(String expr) {
        this.process(InFixExpressionV2.toTokens(expr));
    }

    private static String[] toTokens(String expr) {
        String w = new String(expr);
        w = w.replaceAll(" ", "");
        w = w.replaceAll("\\+", "\\;\\+\\;");
        w = w.replaceAll("\\-", "\\;\\-\\;");
        w = w.replaceAll("\\*", "\\;\\*\\;");
        w = w.replaceAll("\\/", "\\;\\/\\;");
        w = w.replaceAll("\\^", "\\;\\^\\;");
        w = w.replaceAll("\\,", "\\;\\,\\;");
        w = w.replaceAll("\\(", "\\;\\(\\;");
        w = w.replaceAll("\\)", "\\;\\)\\;");
        w = w.replaceAll("\\;\\;", "\\;");
        return w.split("\\;");
    }

    private void process(String[] tokens) {
        Stack<String> stack = new Stack<String>();
        this.rules = new ArrayList();
        int parameterCount = 1;
        Stack<Integer> paramCountStack = new Stack<Integer>();
        for (String token : tokens) {
            if (this.isNumber(token) || this.isVariable(token) || this.isReference(token)) {
                this.rules.add(token);
                continue;
            }
            if (this.isFunction(token) || token.charAt(0) == '(') {
                if (this.isFunction(token)) {
                    paramCountStack.push(parameterCount);
                    parameterCount = 1;
                }
                stack.push(token);
                continue;
            }
            if (token.equals(",")) {
                ++parameterCount;
                while (stack.size() > 0 && ((String)stack.peek()).charAt(0) != '(') {
                    this.rules.add((String)stack.pop());
                }
                continue;
            }
            if (this.isOperator(token.charAt(0))) {
                while (stack.size() > 0 && ((String)stack.peek()).charAt(0) != '(' && InFixExpressionV2.comparePrecedence(((String)stack.peek()).charAt(0), token.charAt(0))) {
                    this.rules.add((String)stack.pop());
                }
                stack.push(token);
                continue;
            }
            if (!token.equals(")")) continue;
            while (stack.size() > 0 && ((String)stack.peek()).charAt(0) != '(') {
                this.rules.add((String)stack.pop());
            }
            if (stack.size() <= 0) continue;
            stack.pop();
            if (!this.isFunction((String)stack.peek())) continue;
            this.rules.add("" + parameterCount);
            parameterCount = paramCountStack.size() > 0 ? (Integer)paramCountStack.pop() : 1;
            this.rules.add((String)stack.pop());
        }
        while (stack.size() > 0) {
            this.rules.add((String)stack.pop());
        }
    }

    private boolean isNumber(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isOperator(char c) {
        return "+-*/^".indexOf(c) != -1;
    }

    private boolean isVariable(String s) {
        return s.startsWith("$");
    }

    private boolean isFunction(String s) {
        return s.startsWith("@");
    }

    private boolean isReference(String s) {
        return s.startsWith("#");
    }

    private static boolean comparePrecedence(char top, char p_2) {
        return InFixExpressionV2.getOpVal(top) > InFixExpressionV2.getOpVal(p_2);
    }

    private static int getOpVal(char op) {
        switch (op) {
            case '(': {
                return 4;
            }
            case '^': {
                return 3;
            }
            case '*': 
            case '/': {
                return 2;
            }
            case '+': 
            case '-': {
                return 1;
            }
        }
        return 0;
    }

    public int getValue(VariableProvider varProvider, FunctionProvider funcProvider) {
        Stack<Integer> workingStack = new Stack<Integer>();
        int stackCountModifier = 0;
        block12: for (String exp : this.rules) {
            int i = 0;
            switch (exp.charAt(0)) {
                case '+': {
                    i = (Integer)workingStack.pop();
                    workingStack.push((Integer)workingStack.pop() + i);
                    break;
                }
                case '-': {
                    i = (Integer)workingStack.pop();
                    workingStack.push((Integer)workingStack.pop() - i);
                    break;
                }
                case '*': {
                    i = (Integer)workingStack.pop();
                    workingStack.push((Integer)workingStack.pop() * i);
                    break;
                }
                case '/': {
                    i = (Integer)workingStack.pop();
                    workingStack.push((Integer)workingStack.pop() / i);
                    break;
                }
                case '^': {
                    i = (Integer)workingStack.pop();
                    workingStack.push((int)Math.pow(((Integer)workingStack.pop()).intValue(), i));
                    break;
                }
                case '$': {
                    String var = exp.substring(1);
                    if (varProvider == null) {
                        workingStack.push(0);
                        break;
                    }
                    workingStack.push(varProvider.resolveVariable(var));
                    break;
                }
                case '@': {
                    String func = exp.substring(1);
                    int pc = (Integer)workingStack.pop();
                    stackCountModifier = 0;
                    if (workingStack.size() < (pc += stackCountModifier)) {
                        throw new IllegalStateException("Invalid number of parameters left on stack");
                    }
                    int[] params = new int[pc];
                    for (int ii = 0; ii < pc; ++ii) {
                        params[ii] = (Integer)workingStack.pop();
                    }
                    try {
                        workingStack.push(funcProvider.resolveFunction(func, params));
                        break;
                    }
                    catch (UnresolvedFunctionException e) {
                        e.printStackTrace();
                        return 0;
                    }
                }
                case '#': {
                    String array = exp.substring(1);
                    if (varProvider == null) {
                        throw new IllegalStateException("Expression contains a reference, no variable provider available.");
                    }
                    int[] arr = varProvider.resolveReference(array);
                    stackCountModifier += arr.length - 1;
                    for (int ii : arr) {
                        workingStack.push(ii);
                    }
                    continue block12;
                }
                default: {
                    workingStack.push(Integer.parseInt(exp));
                }
            }
        }
        if (workingStack.size() == 0) {
            throw new IllegalArgumentException("Expression resulted in a empty stack!");
        }
        return (Integer)workingStack.pop();
    }

    public static void l(String n) {
    }
}

