/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.utils.expressions;

import com.tehbeard.utils.expressions.VariableProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class InFixExpression {
    List<String> expr = new ArrayList<String>();

    public InFixExpression(String expr) {
        for (String exp : InFixExpression.convertInfixToPostfix(expr).split(" ")) {
            if (exp.length() <= 0) continue;
            this.expr.add(exp);
        }
    }

    private static String convertInfixToPostfix(String infix) {
        int length = infix.length();
        Stack<Character> stack = new Stack<Character>();
        StringBuilder postfix = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (infix.charAt(i) == '(') {
                stack.push(Character.valueOf(infix.charAt(i)));
                postfix.append(" ");
                continue;
            }
            if (infix.charAt(i) == '^' || infix.charAt(i) == '*' || infix.charAt(i) == '+' || infix.charAt(i) == '-' || infix.charAt(i) == '/') {
                while (stack.size() > 0 && ((Character)stack.peek()).charValue() != '(' && InFixExpression.comparePrecedence(((Character)stack.peek()).charValue(), infix.charAt(i))) {
                    postfix.append(" " + stack.pop() + " ");
                }
                stack.push(Character.valueOf(infix.charAt(i)));
                postfix.append(" ");
                continue;
            }
            if (infix.charAt(i) == ')') {
                while (stack.size() > 0 && ((Character)stack.peek()).charValue() != '(') {
                    postfix.append(" " + stack.pop() + " ");
                }
                if (stack.size() <= 0) continue;
                stack.pop();
                continue;
            }
            if (infix.charAt(i) == ' ') continue;
            postfix.append(infix.charAt(i));
        }
        while (stack.size() > 0) {
            postfix.append(" " + stack.pop() + " ");
        }
        return postfix.toString().replaceAll("  ", " ");
    }

    private static boolean comparePrecedence(char top, char p_2) {
        return InFixExpression.getOpVal(top) > InFixExpression.getOpVal(p_2);
    }

    private static int getOpVal(char op) {
        switch (op) {
            case '(': {
                return 4;
            }
            case '^': {
                return 3;
            }
            case '*': 
            case '/': {
                return 2;
            }
            case '+': 
            case '-': {
                return 1;
            }
        }
        return 0;
    }

    public int getValue(VariableProvider provider) {
        Stack<Integer> stack = new Stack<Integer>();
        block8: for (String exp : this.expr) {
            int i = 0;
            switch (exp.charAt(0)) {
                case '+': {
                    i = (Integer)stack.pop();
                    stack.push((Integer)stack.pop() + i);
                    continue block8;
                }
                case '-': {
                    i = (Integer)stack.pop();
                    stack.push((Integer)stack.pop() - i);
                    continue block8;
                }
                case '*': {
                    i = (Integer)stack.pop();
                    stack.push((Integer)stack.pop() * i);
                    continue block8;
                }
                case '/': {
                    i = (Integer)stack.pop();
                    stack.push((Integer)stack.pop() / i);
                    continue block8;
                }
                case '^': {
                    i = (Integer)stack.pop();
                    stack.push((int)Math.pow(((Integer)stack.pop()).intValue(), i));
                    continue block8;
                }
                case '$': {
                    String stat = exp.substring(1);
                    if (provider == null) {
                        stack.push(0);
                        continue block8;
                    }
                    stack.push(provider.resolveVariable(stat));
                    continue block8;
                }
            }
            stack.push(Integer.parseInt(exp));
        }
        if (stack.size() == 0) {
            throw new IllegalArgumentException("Expression resulted in a empty stack!");
        }
        return (Integer)stack.pop();
    }

    public static void main(String[] args) {
        System.out.println(new InFixExpression("5*4^2").getValue(null));
    }
}

