/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.utils.cuboid;

import com.tehbeard.utils.Vec3;
import com.tehbeard.utils.cuboid.Cuboid;
import com.tehbeard.utils.cuboid.CuboidEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ChunkCache<T> {
    private HashMap<String, HashSet<CuboidEntry<T>>> cache;

    public ChunkCache() {
        this.clearCache();
    }

    public void clearCache() {
        this.cache = new HashMap();
    }

    public void addEntry(Cuboid cuboid, T entry) {
        CuboidEntry<T> cuboidEntry = new CuboidEntry<T>(cuboid, entry);
        for (String tag : cuboid.getChunks()) {
            if (!this.cache.containsKey(tag)) {
                this.cache.put(tag, new HashSet());
            }
            this.cache.get(tag).add(cuboidEntry);
        }
    }

    public List<CuboidEntry<T>> getEntries(Vec3 loc, String dim) {
        String world = dim;
        String cx = "" + (int)(Math.floor(loc.x) / 16.0);
        String cz = "" + (int)(Math.floor(loc.z) / 16.0);
        ArrayList<CuboidEntry<T>> ret = new ArrayList<CuboidEntry<T>>();
        if (this.cache.containsKey("" + world + "," + cx + "," + cz)) {
            for (CuboidEntry<T> entry : this.cache.get("" + world + "," + cx + "," + cz)) {
                if (!entry.getCuboid().isInside(loc)) continue;
                ret.add(entry);
            }
        }
        return ret;
    }

    public void remove(T entry) {
        for (HashSet<CuboidEntry<T>> e : this.cache.values()) {
            Iterator<CuboidEntry<T>> it = e.iterator();
            while (it.hasNext()) {
                CuboidEntry<T> ee = it.next();
                if (!ee.getEntry().equals(entry)) continue;
                it.remove();
            }
        }
    }
}

