/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.utils.addons;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public abstract class AddonLoader<T> {
    private File dir;
    private URLClassLoader loader;
    private Class<T> addonClass;

    public AddonLoader(File dir, Class<T> addonClass) {
        this.addonClass = addonClass;
        this.dir = dir;
        if (!dir.isDirectory()) {
            throw new IllegalStateException("dir must be a directory!");
        }
    }

    public void loadAddons() {
        String[] flist = this.dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String filename) {
                return !file.isFile() || !filename.endsWith(".jar");
            }
        });
        ArrayList<String> classList = new ArrayList<String>();
        URL[] urls = new URL[flist.length];
        int i = 0;
        for (String file : flist) {
            File addonFile = new File(this.dir, file);
            try {
                urls[i] = addonFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                System.out.println("Could not parse a path");
                e.printStackTrace();
                return;
            }
            ++i;
            try {
                ZipFile addon = new ZipFile(addonFile);
                classList.addAll(this.getClassList(addon));
                this.loader = new URLClassLoader(urls, this.getClass().getClassLoader());
                for (String t : classList) {
                    try {
                        Class<?> c = this.loader.loadClass(t);
                        if (c == null || !this.addonClass.isAssignableFrom(c)) continue;
                        Class<?> tc = c;
                        this.makeClass(tc);
                    }
                    catch (ClassNotFoundException e) {
                        System.out.println("Could not find class! " + t);
                        e.printStackTrace();
                    }
                }
            }
            catch (ZipException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public abstract void makeClass(Class<? extends T> var1);

    public abstract List<String> getClassList(ZipFile var1);
}

