/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TimerArray<T> {
    private Map<T, Long> timings = new HashMap<T, Long>();

    public void addNow(T object) {
        this.add(object, System.currentTimeMillis());
    }

    public void addFuture(T object, long millisecondsFuture) {
        this.add(object, System.currentTimeMillis() + millisecondsFuture);
    }

    public void add(T object, long time) {
        this.timings.put(object, time);
    }

    public void remove(T object) {
        this.timings.remove(object);
    }

    public void removeAll(List<T> object) {
        for (T o : object) {
            this.remove(o);
        }
    }

    public List<T> timeElapsed(Long millisecondsPast) {
        ArrayList<T> past = new ArrayList<T>();
        long t = System.currentTimeMillis();
        for (Map.Entry<T, Long> entry : this.timings.entrySet()) {
            if (entry.getValue() + millisecondsPast >= t) continue;
            past.add(entry.getKey());
        }
        return past;
    }

    public List<T> timeElapsed() {
        return this.timeElapsed(0L);
    }
}

