/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.utils.sql;

import com.tehbeard.utils.CallbackMatcher;
import com.tehbeard.utils.sql.DBVersion;
import com.tehbeard.utils.sql.PostUpgrade;
import com.tehbeard.utils.sql.PreUpgrade;
import com.tehbeard.utils.sql.SQLFragment;
import com.tehbeard.utils.sql.SQLInitScript;
import com.tehbeard.utils.sql.SQLRaw;
import com.tehbeard.utils.sql.SQLRawSet;
import com.tehbeard.utils.sql.SQLScript;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.MatchResult;

public abstract class JDBCDataSource {
    protected Connection connection;
    protected final Logger logger;
    private String connectionUrl;
    protected final Properties connectionProperties = new Properties();
    protected final String scriptSuffix;
    private Properties sqlFragments;
    private final Properties sqlTags = new Properties();
    private final JDBCKeyValStore kvStore = new JDBCKeyValStore();
    private static final CallbackMatcher matcher = new CallbackMatcher("\\$\\{([A-Za-z0-9_]*)\\}");
    public static final String KEY_SCHEMA_VERSION = "schema_version";

    public void setTag(String key, String value) {
        this.sqlTags.setProperty(key, value);
    }

    public JDBCDataSource(String type, String driverClass, Logger logger) throws ClassNotFoundException {
        try {
            Class.forName(driverClass);
            this.logger = logger;
            this.scriptSuffix = type;
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "JDBC {0} Library not found!", driverClass);
            throw e;
        }
    }

    protected void setSqlFragments(Properties sqlFragments) {
        this.sqlFragments = sqlFragments;
    }

    protected void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public void setup() throws SQLException {
        this.connection = DriverManager.getConnection(this.connectionUrl, this.connectionProperties);
        this.invokeCreateTable();
        this.kvStore.setup(this);
        this.prepareStatementCalls();
    }

    public synchronized boolean checkConnection() {
        this.logger.fine("Checking connection");
        try {
            if (this.connection == null || !this.connection.isValid(0)) {
                this.logger.fine("Connection down, reestablishing.");
                this.setup();
            }
        }
        catch (SQLException e) {
            this.connection = null;
            return false;
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        return this.connection != null;
    }

    private void prepareStatementCalls() throws SQLException {
        for (Class<?> c : this.getClasses()) {
            for (Field f : c.getDeclaredFields()) {
                Annotation script;
                if (!PreparedStatement.class.isAssignableFrom(f.getType())) continue;
                if (f.isAnnotationPresent(SQLScript.class)) {
                    script = null;
                    try {
                        script = f.getAnnotation(SQLScript.class);
                        f.setAccessible(true);
                        f.set(this, this.getStatementFromScript(script.value(), script.flags()));
                        continue;
                    }
                    catch (IllegalArgumentException ex) {
                        Logger.getLogger(JDBCDataSource.class.getName()).log(Level.SEVERE, null, ex);
                        throw new SQLException("Failed to load script", ex);
                    }
                    catch (IllegalAccessException ex) {
                        Logger.getLogger(JDBCDataSource.class.getName()).log(Level.SEVERE, null, ex);
                        throw new SQLException("Access error on script field", ex);
                    }
                    catch (Exception ex) {
                        throw new SQLException("Unknown error on script " + script.value(), ex);
                    }
                }
                if (f.isAnnotationPresent(SQLFragment.class)) {
                    script = null;
                    try {
                        script = f.getAnnotation(SQLFragment.class);
                        f.setAccessible(true);
                        f.set(this, this.connection.prepareStatement(this.processSQL(this.sqlFragments.getProperty(script.value() + "." + this.scriptSuffix)), script.flags()));
                        continue;
                    }
                    catch (IllegalArgumentException ex) {
                        Logger.getLogger(JDBCDataSource.class.getName()).log(Level.SEVERE, null, ex);
                        throw new SQLException("Failed to load fragment", ex);
                    }
                    catch (IllegalAccessException ex) {
                        Logger.getLogger(JDBCDataSource.class.getName()).log(Level.SEVERE, null, ex);
                        throw new SQLException("Access error on script fragment", ex);
                    }
                    catch (Exception ex) {
                        throw new SQLException("Unknown error on script fragment " + script.value(), ex);
                    }
                }
                if (!f.isAnnotationPresent(SQLRawSet.class)) continue;
                SQLRawSet set = f.getAnnotation(SQLRawSet.class);
                try {
                    String script2 = null;
                    int flags = 0;
                    for (SQLRaw raw : set.value()) {
                        if (!raw.type().equals(this.scriptSuffix)) continue;
                        script2 = raw.sql();
                        flags = raw.flags();
                    }
                    if (script2 == null) {
                        throw new SQLException("No @SQLRaw found for " + f.getName() + " for type " + this.scriptSuffix);
                    }
                    f.setAccessible(true);
                    f.set(this, this.connection.prepareStatement(this.processSQL(script2), flags));
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(JDBCDataSource.class.getName()).log(Level.SEVERE, null, ex);
                    throw new SQLException("Failed to load raw", ex);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(JDBCDataSource.class.getName()).log(Level.SEVERE, null, ex);
                    throw new SQLException("Access error on script raw", ex);
                }
                catch (Exception ex) {
                    throw new SQLException("Unknown error on script raw " + f.getName(), ex);
                }
            }
        }
    }

    private void invokeCreateTable() throws SQLException {
        for (Class<?> f : this.getClasses()) {
            if (!f.isAnnotationPresent(SQLInitScript.class)) continue;
            this.executeScript(f.getAnnotation(SQLInitScript.class).value());
        }
    }

    private List<Class<?>> getClasses() {
        ArrayList classes = new ArrayList();
        for (Class<?> c = this.getClass(); c != Object.class; c = c.getSuperclass()) {
            classes.add(c);
        }
        return classes;
    }

    public void teardown() throws SQLException {
        this.connection.close();
    }

    public String readSQL(String filename) {
        this.logger.log(Level.FINE, "Loading SQL: {0}", filename);
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(filename + "." + this.scriptSuffix);
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(filename + ".sql");
        }
        if (is == null) {
            throw new IllegalArgumentException("No SQL file found with name " + filename);
        }
        Scanner scanner = new Scanner(is);
        String sql = scanner.useDelimiter("\\Z").next().replaceAll("\\Z", "").replaceAll("\\n|\\r", " ");
        scanner.close();
        return this.processSQL(sql);
    }

    public void executeScript(String scriptName) throws SQLException {
        this.executeScript(scriptName, new HashMap<String, String>());
    }

    public String processSQL(String sql) {
        return this.processSQL(sql, new HashMap<String, String>());
    }

    public String processSQL(String sql, final Map<String, String> keys) {
        return matcher.replaceMatches(sql, new CallbackMatcher.Callback(){

            @Override
            public String foundMatch(MatchResult result) {
                if (keys.containsKey(result.group(1))) {
                    return (String)keys.get(result.group(1));
                }
                if (JDBCDataSource.this.sqlTags.containsKey(result.group(1))) {
                    return JDBCDataSource.this.sqlTags.getProperty(result.group(1));
                }
                throw new IllegalArgumentException("Key " + result.group(1) + " not found.");
            }
        }).trim();
    }

    public String getSQLTag(String tag) {
        return this.sqlTags.getProperty(tag, "");
    }

    public void executeScript(String scriptName, Map<String, String> keys) throws SQLException {
        String[] sqlStatements;
        for (String s : sqlStatements = this.readSQL(scriptName).split("\\;")) {
            String statement = this.processSQL(s, keys);
            if (statement.startsWith("#!")) {
                String subScript = statement.substring(2);
                this.executeScript(subScript, keys);
                continue;
            }
            if (statement.startsWith("#")) {
                this.logger.log(Level.INFO, "Status : {0}", statement.substring(1));
                continue;
            }
            this.connection.prepareStatement(statement).execute();
        }
    }

    public PreparedStatement getStatementFromScript(String scriptName, int flags) throws SQLException {
        return this.connection.prepareStatement(this.readSQL(scriptName), flags);
    }

    public PreparedStatement getStatementFromScript(String scriptName) throws SQLException {
        return this.connection.prepareStatement(this.readSQL(scriptName));
    }

    public abstract boolean generateBackup(String var1);

    public abstract boolean restoreBackup(String var1);

    protected abstract String getMigrationScriptPath(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doMigration(int toVersion) throws SQLException {
        int fromVersion = this.getSchemaVersion();
        String backupName = "migration." + Math.floor(System.currentTimeMillis() / 1000L) + "@v" + fromVersion;
        if (!this.generateBackup(backupName)) {
            this.logger.severe("Failed to generate backup file, aborting migration");
            throw new SQLException("Backup generation failed.");
        }
        this.connection.setAutoCommit(false);
        for (int migratingTo = fromVersion + 1; migratingTo <= toVersion; ++migratingTo) {
            try {
                this.runCodeFor(migratingTo, PreUpgrade.class);
                this.executeScript(this.getMigrationScriptPath(migratingTo));
                this.runCodeFor(migratingTo, PostUpgrade.class);
                this.getKeyValStore().set(KEY_SCHEMA_VERSION, "" + migratingTo, false);
                this.connection.commit();
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(JDBCDataSource.class.getName()).log(Level.SEVERE, null, ex);
                this.connection.rollback();
                this.restoreBackup(backupName);
                boolean bl = false;
                return bl;
            }
            finally {
                this.connection.setAutoCommit(true);
            }
        }
        this.connection.setAutoCommit(true);
        return true;
    }

    private void runCodeFor(int version, Class<? extends Annotation> ann) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Class<?> c : this.getClasses()) {
            for (Method m : c.getDeclaredMethods()) {
                if (!m.isAnnotationPresent(ann) || m.getAnnotation(DBVersion.class).value() != version) continue;
                m.invoke((Object)this, new Object[0]);
            }
        }
    }

    public JDBCKeyValStore getKeyValStore() {
        return this.kvStore;
    }

    public abstract int getDataSourceVersion();

    public int getSchemaVersion() throws SQLException {
        JDBCKeyValStore.KeyValEntry key = this.getKeyValStore().get(KEY_SCHEMA_VERSION);
        if (key == null) {
            this.getKeyValStore().set(KEY_SCHEMA_VERSION, "" + this.getDataSourceVersion(), true);
            key = this.getKeyValStore().get(KEY_SCHEMA_VERSION);
        }
        return Integer.parseInt(key.value);
    }

    public static final class JDBCKeyValStore {
        @SQLRawSet(value={@SQLRaw(sql="SELECT `key`,`value`,`added` FROM ${PREFIX}_keyval WHERE `key`=? order by `id` DESC LIMIT 1", type="sql")})
        private PreparedStatement get;
        @SQLRawSet(value={@SQLRaw(sql="SELECT `key`,`value`,`added` FROM (SELECT * FROM ${PREFIX}_keyval WHERE `key` IN (?) ORDER BY `id` DESC) _k GROUP BY `key` HAVING `value` IS NOT NULL", type="sql")})
        private PreparedStatement getAll;
        @SQLRawSet(value={@SQLRaw(sql="SELECT `key`,`value`,`added` FROM (SELECT * FROM ${PREFIX}_keyval WHERE `key` NOT IN (?) ORDER BY `id` DESC) _k GROUP BY `key` HAVING `value` IS NOT NULL", type="sql")})
        private PreparedStatement getAllExcept;
        @SQLRawSet(value={@SQLRaw(sql="SELECT `key`,`value`,`added` FROM ${PREFIX}_keyval WHERE `key`=? order by `id` DESC", type="sql")})
        private PreparedStatement getIterations;
        @SQLRawSet(value={@SQLRaw(sql="INSERT INTO ${PREFIX}_keyval (`key`,`value`,`added`,`noCompact`) VALUES(?,?,?,?)", type="sql")})
        private PreparedStatement add;
        @SQLRawSet(value={@SQLRaw(sql="DELETE FROM ${PREFIX}_keyval WHERE `noCompact` = 0 AND `id` NOT IN (SELECT `id` FROM (SELECT * FROM ${PREFIX}_keyval ORDER BY `id` DESC) _k GROUP BY `key` HAVING `value` IS NOT NULL)", type="sql")})
        private PreparedStatement compactAll;
        @SQLRawSet(value={@SQLRaw(sql="DELETE FROM ${PREFIX}_keyval WHERE `key` = ? AND (`id` NOT IN (SELECT `id` FROM (SELECT * FROM ${PREFIX}_keyval ORDER BY `id` DESC) _k GROUP BY `key` HAVING `value` IS NOT NULL) OR `value` IS NULL)", type="sql")})
        private PreparedStatement compact;
        @SQLRawSet(value={@SQLRaw(sql="SELECT Table_Name, concat(CAST(CEIL((Data_length+Index_length)/1024) as char),'kb') as size FROM INFORMATION_SCHEMA.tables WHERE table_schema=?", type="sql")})
        private PreparedStatement getTableInfo;
        private Connection con;

        private void setup(JDBCDataSource source) throws SQLException {
            this.con = source.connection;
            this.con.prepareStatement(source.processSQL("CREATE TABLE IF NOT EXISTS ${PREFIX}_keyval(`id` INT AUTO_INCREMENT,`noCompact` BOOLEAN NOT NULL DEFAULT FALSE, `key` VARCHAR( 255 ) NOT NULL , `value` VARCHAR( 255 ) NULL , `added` TIMESTAMP NOT NULL ,PRIMARY KEY (  `id` ))")).execute();
            for (Field f : this.getClass().getDeclaredFields()) {
                if (!PreparedStatement.class.isAssignableFrom(f.getType()) || !f.isAnnotationPresent(SQLRawSet.class)) continue;
                SQLRawSet set = f.getAnnotation(SQLRawSet.class);
                try {
                    String script = null;
                    int flags = 0;
                    for (SQLRaw raw : set.value()) {
                        if (!raw.type().equals(source.scriptSuffix) && (script != null || !raw.type().equals("sql"))) continue;
                        script = raw.sql();
                        flags = raw.flags();
                    }
                    if (script == null) {
                        throw new SQLException("No @SQLRaw found for " + f.getName() + " for type " + source.scriptSuffix);
                    }
                    f.setAccessible(true);
                    f.set(this, source.connection.prepareStatement(source.processSQL(script), flags));
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(JDBCDataSource.class.getName()).log(Level.SEVERE, null, ex);
                    throw new SQLException("Failed to load raw", ex);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(JDBCDataSource.class.getName()).log(Level.SEVERE, null, ex);
                    throw new SQLException("Access error on script raw", ex);
                }
                catch (Exception ex) {
                    throw new SQLException("Unknown error on script raw " + f.getName(), ex);
                }
            }
        }

        public Map<String, String> getTableInfo() throws SQLException {
            this.getTableInfo.setString(1, this.con.getSchema());
            ResultSet rs = this.getTableInfo.executeQuery();
            HashMap<String, String> data = new HashMap<String, String>();
            while (rs.next()) {
                data.put(rs.getString(1), rs.getString(2));
            }
            rs.close();
            return data;
        }

        public void set(String key, String value) throws SQLException {
            this.set(key, value, false);
        }

        public void set(String key, String value, boolean noCompact) throws SQLException {
            this.add.setString(1, key);
            this.add.setString(2, value);
            this.add.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            this.add.setBoolean(4, noCompact);
            this.add.execute();
        }

        public KeyValEntry get(String key) throws SQLException {
            this.get.setString(1, key);
            ResultSet rs = this.get.executeQuery();
            if (rs.next()) {
                KeyValEntry k = new KeyValEntry(rs.getString(1), rs.getString(2), rs.getTimestamp(3).getTime());
                rs.close();
                return k;
            }
            return null;
        }

        public boolean hasKey(String key) throws SQLException {
            this.get.setString(1, key);
            ResultSet rs = this.get.executeQuery();
            boolean res = rs.next();
            rs.close();
            return res;
        }

        public Map<String, KeyValEntry> getAll() throws SQLException {
            this.getAll.setString(1, "");
            ResultSet rs = this.getAll.executeQuery();
            HashMap<String, KeyValEntry> res = new HashMap<String, KeyValEntry>();
            while (rs.next()) {
                res.put(rs.getString(1), new KeyValEntry(rs.getString(1), rs.getString(2), rs.getTimestamp(3).getTime()));
            }
            rs.close();
            return res;
        }

        public List<KeyValEntry> getIterations(String key) throws SQLException {
            this.getIterations.setString(1, key);
            ResultSet rs = this.getIterations.executeQuery();
            ArrayList<KeyValEntry> res = new ArrayList<KeyValEntry>();
            while (rs.next()) {
                res.add(new KeyValEntry(rs.getString(1), rs.getString(2), rs.getTimestamp(3).getTime()));
            }
            rs.close();
            return res;
        }

        public void compactAll() throws SQLException {
            this.compactAll.execute();
        }

        public void compact(String key) throws SQLException {
            this.compact.setString(1, key);
            this.compact.execute();
        }

        public class KeyValEntry {
            public final String key;
            public final String value;
            public final long added;

            public KeyValEntry(String key, String value, long added) {
                this.key = key;
                this.value = value;
                this.added = added;
            }

            public String toString() {
                return "KeyValEntry{key=" + this.key + ", value=" + this.value + ", added=" + this.added + '}';
            }
        }
    }
}

