/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.utils.expressions.functions;

import com.tehbeard.utils.expressions.UnresolvedFunctionException;
import com.tehbeard.utils.expressions.functions.Function;
import com.tehbeard.utils.expressions.functions.FunctionProvider;
import java.util.HashMap;
import java.util.Map;

public class FunctionCatalogue
implements FunctionProvider {
    Map<String, FunctionProvider> providers = new HashMap<String, FunctionProvider>();

    public FunctionCatalogue() {
    }

    public FunctionCatalogue(FunctionProvider ... providers) {
        this();
        for (FunctionProvider provider : providers) {
            Function f = provider.getClass().getAnnotation(Function.class);
            if (f == null) continue;
            for (String name : f.value()) {
                this.providers.put(name, provider);
            }
        }
    }

    @Override
    public int resolveFunction(String function, int[] params) throws UnresolvedFunctionException {
        FunctionProvider provider = this.providers.get(function);
        if (provider == null) {
            throw new UnresolvedFunctionException();
        }
        return provider.resolveFunction(function, params);
    }
}

