/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.utils.cuboid.selector;

import com.tehbeard.utils.Vec3;
import com.tehbeard.utils.cuboid.Cuboid;
import com.tehbeard.utils.session.SessionStore;
import java.util.HashSet;
import java.util.Set;

public class CuboidSelector {
    private final SessionStore<Cuboid> session = new SessionStore();
    StatusIndicator indicator;
    private final Set<String> active = new HashSet<String>();

    public CuboidSelector(StatusIndicator indicator) {
        this.indicator = indicator;
    }

    private void indicate(StatusIndicator.Activity activity, String player, Cuboid cuboid) {
        if (this.indicator != null) {
            this.indicator.cuboidUpdate(activity, player, cuboid);
        }
    }

    public void setActive(String player) {
        this.active.add(player);
        this.session.putSession(player, new Cuboid());
        this.indicate(StatusIndicator.Activity.ACTIVE, player, null);
    }

    public void setInActive(String player) {
        this.active.remove(player);
        this.session.clearSession(player);
        this.indicate(StatusIndicator.Activity.INACTIVE, player, null);
    }

    public boolean isActive(String player) {
        return this.active.contains(player);
    }

    public boolean toggle(String player) {
        if (this.isActive(player)) {
            this.setInActive(player);
        } else {
            this.setActive(player);
        }
        return this.isActive(player);
    }

    public boolean leftClick(String player, Vec3 vec) {
        if (!this.isActive(player)) {
            return false;
        }
        this.session.getSession(player).setV1(vec);
        this.indicate(StatusIndicator.Activity.SELECT_CORNER_ONE, player, this.session.getSession(player));
        return true;
    }

    public boolean rightClick(String player, Vec3 vec) {
        if (!this.isActive(player)) {
            return false;
        }
        this.session.getSession(player).setV1(vec);
        this.indicate(StatusIndicator.Activity.SELECT_CORNER_TWO, player, this.session.getSession(player));
        return true;
    }

    public Cuboid getCuboid(String player) {
        return this.session.getSession(player);
    }

    public static interface StatusIndicator {
        public void cuboidUpdate(Activity var1, String var2, Cuboid var3);

        public static enum Activity {
            SELECT_CORNER_ONE,
            SELECT_CORNER_TWO,
            ACTIVE,
            INACTIVE;

        }
    }
}

