/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.utils.sql;

import com.tehbeard.utils.intake.Command;
import com.tehbeard.utils.sql.CLIJDBCDataSource;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TestJDBCClass
extends CLIJDBCDataSource {
    public TestJDBCClass(String type, String driverClass, Logger logger) throws ClassNotFoundException {
        super(type, driverClass, logger);
    }

    @Override
    protected String getMigrationScriptPath(int toVersion) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean generateBackup(String name) {
        return true;
    }

    @Override
    public boolean restoreBackup(String name) {
        return true;
    }

    @Override
    public int getDataSourceVersion() {
        return 3;
    }

    public static CLIJDBCDataSource getConsoleInstance(String[] args) {
        try {
            Logger logger = Logger.getLogger("CLI");
            logger.setLevel(Level.INFO);
            TestJDBCClass db = new TestJDBCClass("sql", "com.mysql.jdbc.Driver", logger);
            db.setTag("PREFIX", "stats");
            db.setConnectionUrl(String.format("jdbc:mysql://%s:%s/%s", "127.0.0.1", "3306", "test"));
            return db;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Command(aliases={"version"}, desc="Get schema version", help="Returns the schema version")
    public void commandDbVersion() throws SQLException {
        this.logger.log(Level.INFO, "Schema is {0}", this.getSchemaVersion());
    }

    @Command(aliases={"poke"}, desc="Test KeyVal", help="")
    public void pokeKeyVal() throws SQLException {
        this.getKeyValStore().set("a", "first", true);
        this.getKeyValStore().set("a", "second", true);
        this.getKeyValStore().set("a", "third", true);
        this.getKeyValStore().set("b", "first");
        this.getKeyValStore().set("b", "second");
        this.getKeyValStore().set("b", "third");
        this.getKeyValStore().compact("a");
    }

    public static void main(String[] args) {
        TestJDBCClass.doCLI(TestJDBCClass.getConsoleInstance(args), args);
    }
}

