/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.utils.factory;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class ConfigurableFactory<C, A> {
    protected Map<String, Class<? extends C>> products;
    private Class<? extends Annotation> annotation;

    public ConfigurableFactory(Class<? extends Annotation> annotation) {
        this.annotation = annotation;
        this.products = new HashMap<String, Class<? extends C>>();
    }

    public boolean addProduct(Class<? extends C> product) {
        String t;
        Annotation tag = product.getAnnotation(this.annotation);
        if (tag != null && (t = this.getTag(tag)) != null) {
            this.products.put(t, product);
            return true;
        }
        return false;
    }

    public C getProduct(String tag) throws IllegalStateException {
        if (this.products.containsKey(tag)) {
            try {
                return this.produce(tag);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Could not create instance of the object");
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Could not create instance of the object due to an access exception");
            }
        }
        return null;
    }

    protected C produce(String tag) throws InstantiationException, IllegalAccessException {
        return this.products.get(tag).newInstance();
    }

    public abstract String getTag(A var1);

    public Set<String> getTags() {
        return this.products.keySet();
    }
}

