/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.utils.intake.parametric;

import com.google.common.base.Preconditions;
import com.tehbeard.utils.intake.Command;
import com.tehbeard.utils.intake.CommandCallable;
import com.tehbeard.utils.intake.completion.CommandCompleter;
import com.tehbeard.utils.intake.completion.NullCompleter;
import com.tehbeard.utils.intake.dispatcher.Dispatcher;
import com.tehbeard.utils.intake.parametric.ParametricCallable;
import com.tehbeard.utils.intake.parametric.ParametricException;
import com.tehbeard.utils.intake.parametric.binding.Binding;
import com.tehbeard.utils.intake.parametric.binding.PrimitiveBindings;
import com.tehbeard.utils.intake.parametric.binding.StandardBindings;
import com.tehbeard.utils.intake.parametric.handler.ExceptionConverter;
import com.tehbeard.utils.intake.parametric.handler.InvokeListener;
import com.tehbeard.utils.intake.util.auth.Authorizer;
import com.tehbeard.utils.intake.util.auth.NullAuthorizer;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParametricBuilder {
    private final Map<Type, Binding> bindings = new HashMap<Type, Binding>();
    private final List<InvokeListener> invokeListeners = new ArrayList<InvokeListener>();
    private final List<ExceptionConverter> exceptionConverters = new ArrayList<ExceptionConverter>();
    private Authorizer authorizer = new NullAuthorizer();
    private CommandCompleter defaultCompleter = new NullCompleter();

    public ParametricBuilder() {
        this.addBinding(new PrimitiveBindings(), new Type[0]);
        this.addBinding(new StandardBindings(), new Type[0]);
    }

    public void addBinding(Binding binding, Type ... type) {
        Preconditions.checkNotNull((Object)binding);
        if (type == null || type.length == 0) {
            type = binding.getTypes();
        }
        for (Type t : type) {
            this.bindings.put(t, binding);
        }
    }

    public void addInvokeListener(InvokeListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.invokeListeners.add(listener);
    }

    public void addExceptionConverter(ExceptionConverter converter) {
        Preconditions.checkNotNull((Object)converter);
        this.exceptionConverters.add(converter);
    }

    public void registerMethodsAsCommands(Dispatcher dispatcher, Object object) throws ParametricException {
        Preconditions.checkNotNull((Object)dispatcher);
        Preconditions.checkNotNull((Object)object);
        for (Method method : object.getClass().getDeclaredMethods()) {
            Command definition = method.getAnnotation(Command.class);
            if (definition == null) continue;
            CommandCallable callable = this.build(object, method, definition);
            dispatcher.registerCommand(callable, definition.aliases());
        }
    }

    private CommandCallable build(Object object, Method method, Command definition) throws ParametricException {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkNotNull((Object)method);
        return new ParametricCallable(this, object, method, definition);
    }

    Map<Type, Binding> getBindings() {
        return this.bindings;
    }

    List<InvokeListener> getInvokeListeners() {
        return this.invokeListeners;
    }

    List<ExceptionConverter> getExceptionConverters() {
        return this.exceptionConverters;
    }

    public Authorizer getAuthorizer() {
        return this.authorizer;
    }

    public void setAuthorizer(Authorizer authorizer) {
        Preconditions.checkNotNull((Object)authorizer);
        this.authorizer = authorizer;
    }

    public CommandCompleter getDefaultCompleter() {
        return this.defaultCompleter;
    }

    public void setDefaultCompleter(CommandCompleter defaultCompleter) {
        Preconditions.checkNotNull((Object)defaultCompleter);
        this.defaultCompleter = defaultCompleter;
    }
}

