/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.utils.intake;

import com.google.common.base.Preconditions;
import com.tehbeard.beardstat.utils.intake.CommandCallable;
import com.tehbeard.beardstat.utils.intake.CommandMapping;
import com.tehbeard.beardstat.utils.intake.Description;
import java.util.Arrays;

public class ImmutableCommandMapping
implements CommandMapping {
    private final String[] aliases;
    private final CommandCallable callable;

    public ImmutableCommandMapping(CommandCallable callable, String ... alias) {
        Preconditions.checkNotNull((Object)callable);
        Preconditions.checkNotNull((Object)alias);
        this.aliases = Arrays.copyOf(alias, alias.length);
        this.callable = callable;
    }

    @Override
    public String getPrimaryAlias() {
        return this.aliases[0];
    }

    @Override
    public String[] getAllAliases() {
        return this.aliases;
    }

    @Override
    public CommandCallable getCallable() {
        return this.callable;
    }

    @Override
    public Description getDescription() {
        return this.getCallable().getDescription();
    }

    public String toString() {
        return "CommandMapping{aliases=" + Arrays.toString(this.aliases) + ", callable=" + this.callable + '}';
    }
}

