/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.utils.deferred.promise;

import com.tehbeard.beardstat.utils.deferred.promise.Delegate;
import com.tehbeard.beardstat.utils.deferred.promise.Promise;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Deferred<T>
implements Promise<T>,
Runnable {
    private static Logger log = Logger.getLogger(Deferred.class.getName());
    private ConcurrentLinkedQueue<Delegate<Void, Promise<T>>> progressCallbacks = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Delegate<Void, Promise<T>>> resolveCallbacks = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Delegate<Void, Promise<T>>> rejectCallbacks = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Delegate<Void, Promise<T>>> alwaysCallbacks = new ConcurrentLinkedQueue();
    private AtomicReference<Promise.State> state = new AtomicReference<Promise.State>(Promise.State.DEFERRED);
    private T value;
    private Throwable error;
    private Object progress = null;

    public static Promise<Promise<?>[]> when(Object ... promises) {
        final Promise[] promiseArray = new Promise[promises.length];
        final AtomicInteger numResolved = new AtomicInteger();
        final Deferred<Promise<?>[]> promise = new Deferred<Promise<?>[]>();
        Delegate<Void, Promise<Object>> handler = new Delegate<Void, Promise<Object>>(){

            @Override
            public <P extends Promise<Object>> Void invoke(P params) {
                if (params.isRejected()) {
                    promise.reject(params.getError());
                } else {
                    int total = numResolved.getAndIncrement();
                    if (total == promiseArray.length - 1) {
                        promise.resolve(promiseArray);
                    }
                }
                return null;
            }
        };
        for (int i = 0; i < promises.length; ++i) {
            promiseArray[i] = promises[i] != null && promises[i] instanceof Promise ? (Promise)promises[i] : new Deferred<Object>(promises[i]);
            promiseArray[i].onDone(handler);
        }
        return promise;
    }

    public Deferred() {
    }

    public Deferred(T object) {
        this();
        this.resolve(object);
    }

    protected void doCallbacks() {
        if (!this.isDone()) {
            return;
        }
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Throwable getError() {
        while (!this.isDone()) {
            AtomicReference<Promise.State> atomicReference = this.state;
            synchronized (atomicReference) {
                try {
                    this.state.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (!this.isRejected()) {
            throw new IllegalStateException("Promise was resolved");
        }
        return this.error;
    }

    @Override
    public Object getProgress() {
        return this.progress;
    }

    @Override
    public Promise.State getState() {
        return this.state.get();
    }

    @Override
    public T getValue() {
        this.waitForResolution();
        if (this.isRejected()) {
            throw new IllegalStateException("Promise was rejected", this.getError());
        }
        return this.value;
    }

    @Override
    public boolean isDone() {
        return this.getState() != Promise.State.DEFERRED;
    }

    @Override
    public boolean isRejected() {
        return this.getState() == Promise.State.REJECTED;
    }

    @Override
    public boolean isResolved() {
        return this.getState() == Promise.State.RESOVLED;
    }

    public Promise<T> notify(Object progress) {
        if (this.isDone()) {
            throw new IllegalStateException("Promise is already finished");
        }
        this.progress = progress;
        for (Delegate<Void, Promise<T>> progressCallback : this.progressCallbacks) {
            progressCallback.invoke(this);
        }
        return this;
    }

    @Override
    public void onDone(Delegate<Void, Promise<T>> callback) {
        if (callback == null) {
            return;
        }
        this.alwaysCallbacks.add(callback);
        this.doCallbacks();
    }

    @Override
    public void onProgress(Delegate<Void, Promise<T>> callback) {
        if (callback == null) {
            return;
        }
        callback.invoke(this);
        if (this.isDone()) {
            return;
        }
        this.progressCallbacks.add(callback);
    }

    @Override
    public void onReject(Delegate<Void, Promise<T>> callback) {
        if (callback == null) {
            return;
        }
        this.rejectCallbacks.add(callback);
        this.doCallbacks();
    }

    @Override
    public void onResolve(Delegate<Void, Promise<T>> callback) {
        if (callback == null) {
            return;
        }
        this.resolveCallbacks.add(callback);
        this.doCallbacks();
    }

    @Override
    public <U> Promise<U> pipe(Delegate<Promise<U>, T> filter) {
        return this.pipe(filter, null, null);
    }

    @Override
    public <U> Promise<U> pipe(Delegate<Promise<U>, T> filter, Delegate<Promise<U>, Throwable> errorFilter) {
        return this.pipe(filter, errorFilter, null);
    }

    @Override
    public <U> Promise<U> pipe(Delegate<Promise<U>, T> filter, Delegate<Promise<U>, Throwable> errorFilter, Delegate<Object, Object> progressFilter) {
        Pipe<U> pipe = new Pipe<U>(filter, errorFilter, progressFilter);
        this.onDone(pipe);
        this.onProgress(pipe);
        return pipe;
    }

    @Override
    public Promise<T> pipeError(Delegate<Promise<T>, Throwable> errorFilter) {
        return this.pipe(null, errorFilter, null);
    }

    @Override
    public Promise<T> pipeProgress(Delegate<Object, Object> progressFilter) {
        return this.pipe(null, null, progressFilter);
    }

    public Promise<T> reject(Throwable error) {
        if (!this.state.compareAndSet(Promise.State.DEFERRED, Promise.State.REJECTED)) {
            throw new IllegalStateException("Promise already finished");
        }
        this.error = error;
        this.doCallbacks();
        return this;
    }

    public Promise<T> resolve(T object) {
        if (!this.state.compareAndSet(Promise.State.DEFERRED, Promise.State.RESOVLED)) {
            throw new IllegalStateException("Promise already finished");
        }
        this.value = object;
        this.doCallbacks();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.isDone()) {
            return;
        }
        AtomicReference<Promise.State> atomicReference = this.state;
        synchronized (atomicReference) {
            this.state.notifyAll();
        }
        this.progressCallbacks.clear();
        Delegate<Void, Promise<T>> alwaysCallback = null;
        while ((alwaysCallback = this.alwaysCallbacks.poll()) != null) {
            try {
                alwaysCallback.invoke(this);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error executing callback with Deferred: " + this, e);
            }
        }
        Delegate<Void, Promise<T>> resolveCallback = null;
        while ((resolveCallback = this.resolveCallbacks.poll()) != null) {
            if (!this.isResolved()) continue;
            try {
                resolveCallback.invoke(this);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error executing resolve callback with Deferred: " + this, e);
            }
        }
        Delegate<Void, Promise<T>> rejectCallback = null;
        while ((rejectCallback = this.rejectCallbacks.poll()) != null) {
            if (!this.isRejected()) continue;
            try {
                rejectCallback.invoke(this);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error executing reject callback with Deferred: " + this, e);
            }
        }
    }

    public String toString() {
        return "{" + (Object)((Object)this.state.get()) + (this.isResolved() ? "," + this.getValue() : (this.isRejected() ? "," + this.getError() : "")) + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForResolution() {
        try {
            AtomicReference<Promise.State> atomicReference = this.state;
            synchronized (atomicReference) {
                while (!this.isDone()) {
                    this.state.wait();
                }
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    private class Pipe<U>
    extends Deferred<U>
    implements Delegate<Void, Promise<T>> {
        private final Delegate<Promise<U>, T> resolveFilter;
        private final Delegate<Promise<U>, Throwable> rejectFilter;
        private final Delegate<Object, Object> progressFilter;
        private final Delegate<Void, Promise<U>> proxyPipe = new Delegate<Void, Promise<U>>(){

            @Override
            public <P extends Promise<U>> Void invoke(P promise) {
                if (promise.isRejected()) {
                    Pipe.this.reject(promise.getError());
                }
                if (promise.isResolved()) {
                    Pipe.this.resolve(promise.getValue());
                }
                return null;
            }
        };

        public Pipe(Delegate<Promise<U>, T> resolveFilter, Delegate<Promise<U>, Throwable> rejectFilter, Delegate<Object, Object> progressFilter) {
            this.resolveFilter = resolveFilter;
            this.rejectFilter = rejectFilter;
            this.progressFilter = progressFilter;
        }

        @Override
        public <P extends Promise<T>> Void invoke(P promise) {
            if (promise == null) {
                throw new IllegalArgumentException("Promise may not be null");
            }
            if (!promise.isDone() && this.progressFilter != null) {
                Object progress = promise.getProgress();
                try {
                    this.progressFilter.invoke(progress);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error filtering progress value: " + progress, e);
                }
                this.notify(progress);
                return null;
            }
            try {
                Promise<U> proxy = null;
                if (promise.isRejected()) {
                    proxy = this.rejectFilter.invoke(promise.getError());
                    if (proxy == null) {
                        this.reject(promise.getError());
                        return null;
                    }
                } else if (promise.isResolved() && (proxy = this.resolveFilter.invoke(promise.getValue())) == null) {
                    this.resolve(null);
                    return null;
                }
                if (proxy != null) {
                    proxy.onDone(this.proxyPipe);
                }
            }
            catch (Throwable e) {
                this.reject(e);
            }
            return null;
        }
    }
}

