/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.utils;

import com.tehbeard.beardstat.containers.documents.StatDocument;
import com.tehbeard.beardstat.utils.factory.ClassCatalogue;
import com.tehbeard.beardstat.utils.gson.JsonDeserializationContext;
import com.tehbeard.beardstat.utils.gson.JsonDeserializer;
import com.tehbeard.beardstat.utils.gson.JsonElement;
import com.tehbeard.beardstat.utils.gson.JsonParseException;
import com.tehbeard.beardstat.utils.gson.JsonSerializationContext;
import com.tehbeard.beardstat.utils.gson.JsonSerializer;
import java.lang.reflect.Type;

public class ClassBasedParser<T>
implements JsonSerializer<T>,
JsonDeserializer<T> {
    private final ClassCatalogue<T> catalogue;

    public ClassBasedParser(ClassCatalogue<T> catalogue) {
        this.catalogue = catalogue;
    }

    @Override
    public JsonElement serialize(T t, Type type, JsonSerializationContext context) {
        JsonElement element = context.serialize(t, t.getClass());
        element.getAsJsonObject().addProperty("_type", t.getClass().getAnnotation(StatDocument.class).value());
        return element;
    }

    @Override
    public T deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
        try {
            String id = element.getAsJsonObject().get("_type").getAsString();
            Class<T> c = this.catalogue.get(id);
            if (c != null) {
                return context.deserialize(element, c);
            }
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
        }
        return null;
    }
}

