/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.dataproviders;

import com.tehbeard.beardstat.BeardStatRuntimeException;
import com.tehbeard.beardstat.DatabaseConfiguration;
import com.tehbeard.beardstat.DbPlatform;
import com.tehbeard.beardstat.containers.documents.DocumentHistory;
import com.tehbeard.beardstat.containers.documents.DocumentRegistry;
import com.tehbeard.beardstat.containers.documents.IStatDocument;
import com.tehbeard.beardstat.containers.documents.StatDocument;
import com.tehbeard.beardstat.containers.documents.docfile.DocumentFile;
import com.tehbeard.beardstat.dataproviders.DocumentTooLargeException;
import com.tehbeard.beardstat.dataproviders.IStatDataProvider;
import com.tehbeard.beardstat.dataproviders.JDBCStatDataProvider;
import com.tehbeard.beardstat.dataproviders.sqlite.DocEntry;
import com.tehbeard.beardstat.dataproviders.sqlite.DocumentDatabase;
import com.tehbeard.beardstat.utils.FileUtils;
import com.tehbeard.beardstat.utils.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class SQLiteStatDataProvider
extends JDBCStatDataProvider {
    private final String filename;
    private DocumentDatabase docDB;
    private File docDbFile;

    public SQLiteStatDataProvider(DbPlatform platform, String filename, DatabaseConfiguration config) throws SQLException, ClassNotFoundException {
        super(platform, "sqlite", "org.sqlite.JDBC", config);
        this.setConnectionUrl(String.format("jdbc:sqlite:%s", filename));
        this.setTag("PREFIX", "stats");
        this.initialise();
        try {
            this.docDbFile = new File(platform.getDataFolder(), "documents.json.gz");
            this.docDB = !this.docDbFile.exists() ? new DocumentDatabase() : DocumentRegistry.instance().fromJson((Reader)new InputStreamReader(new GZIPInputStream(new FileInputStream(this.docDbFile))), DocumentDatabase.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BeardStatRuntimeException("Error generating documents database", e, false);
        }
        this.filename = filename;
    }

    @Override
    public boolean generateBackup(String file) {
        if (this.filename.equals(":memory:")) {
            return true;
        }
        try {
            FileUtils.copy(new File(this.filename), new File(this.platform.getDataFolder(), file));
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(SQLiteStatDataProvider.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Override
    public DocumentFile pullDocument(int entityId, String domain, String key) {
        DocEntry dbEntry = this.docDB.getStore(entityId).getDocumentData(domain, key);
        DocEntry.DocRev docRevision = dbEntry.getRevisions().get(dbEntry.getCurrentRevision());
        if (docRevision == null) {
            return null;
        }
        return new DocumentFile(dbEntry.getCurrentRevision(), docRevision.parentRev, domain, key, docRevision.document, docRevision.dateAdded);
    }

    @Override
    public DocumentFile pushDocument(int entityId, DocumentFile document) throws IStatDataProvider.RevisionMismatchException, DocumentTooLargeException {
        try {
            byte[] doc = DocumentRegistry.instance().toJson(document.getDocument(), DocumentRegistry.getSerializeAs(document.getDocument().getClass())).getBytes();
            if (doc.length > 0x1000000) {
                throw new DocumentTooLargeException("Document exceeds max size.");
            }
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            String newRevision = this.byteArrayToHexString(digest.digest(doc));
            boolean isSingleton = document.getDocument().getClass().getAnnotation(StatDocument.class).singleInstance();
            String currentRevision = document.getRevision();
            DocEntry dbEntry = this.docDB.getStore(entityId).getDocumentData(document.getDomain(), document.getKey());
            if (currentRevision != null && !currentRevision.equals(dbEntry.getCurrentRevision())) {
                throw new IStatDataProvider.RevisionMismatchException(this.pullDocument(entityId, document.getDomain(), document.getKey()));
            }
            dbEntry.getRevisions().put(newRevision, new DocEntry.DocRev(isSingleton ? null : currentRevision, (IStatDocument)document.getDocument()));
            dbEntry.setCurrentRevision(newRevision);
            if (isSingleton) {
                dbEntry.getRevisions().remove(currentRevision);
            }
            DocumentFile d = this.pullDocument(entityId, document.getDomain(), document.getKey());
            d.setOwner(document.getOwner());
            return d;
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(SQLiteStatDataProvider.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public DocumentHistory getDocumentHistory(int entityId, String domain, String key) {
        DocEntry d = this.docDB.getStore(entityId).getDocumentData(domain, key);
        DocumentHistory history = new DocumentHistory(domain, key, d.getCurrentRevision());
        for (Map.Entry<String, DocEntry.DocRev> e : d.getRevisions().entrySet()) {
            history.addEntry(e.getKey(), e.getValue().parentRev, e.getValue().dateAdded);
        }
        return history;
    }

    @Override
    public void deleteDocument(int entityId, String domain, String key) {
        this.docDB.getStore(entityId).deleteDocument(domain, key);
    }

    @Override
    public void deleteDocumentRevision(int entityId, String domain, String key, String revision) {
        this.docDB.getStore(entityId).getDocumentData(domain, key).getRevisions().remove(revision);
        if (this.docDB.getStore(entityId).getDocumentData(domain, key).getRevisions().isEmpty()) {
            this.deleteDocument(entityId, domain, key);
        }
    }

    @Override
    public String[] getDocumentKeysInDomain(int entityId, String domain) {
        return this.docDB.getStore(entityId).getDocsUnderDomain(domain);
    }

    @Override
    public void flush() {
        super.flush();
        try {
            DocumentRegistry.instance().toJson((Object)this.docDB, (Type)((Object)DocumentDatabase.class), new JsonWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(this.docDbFile)))));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SQLiteStatDataProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(SQLiteStatDataProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public boolean restoreBackup(String file) {
        try {
            this.teardown();
            FileUtils.copy(new File(this.platform.getDataFolder(), file), new File(this.filename));
            this.initialise();
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(SQLiteStatDataProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SQLException ex) {
            this.platform.getLogger().log(Level.SEVERE, null, ex);
        }
        return false;
    }
}

