/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.containers;

import com.tehbeard.beardstat.containers.EntityStatBlob;
import com.tehbeard.beardstat.containers.IStat;
import com.tehbeard.beardstat.containers.StaticStat;

public class TimeStat
implements IStat {
    private int value = 0;
    private EntityStatBlob owner;
    private String domain;
    private String world;
    private String statistic;
    private String category;
    private long timerStarted = 0L;

    public TimeStat(EntityStatBlob owner) {
        this.owner = owner;
    }

    public TimeStat(EntityStatBlob owner, String domain, String world, String statistic, String category) {
        this.owner = owner;
        this.domain = domain;
        this.world = world;
        this.statistic = statistic;
        this.category = category;
    }

    @Override
    public void setWorld(String world) {
        this.world = world;
    }

    @Override
    public void setValue(int value) {
        this.value = value;
    }

    @Override
    public void setOwner(EntityStatBlob playerStatBlob) {
        this.owner = this.owner;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public boolean isArchive() {
        return true;
    }

    @Override
    public void incrementStat(int i) {
        this.value += i;
    }

    @Override
    public String getWorld() {
        return "__global__";
    }

    @Override
    public int getValue() {
        return this.value + this.getTime();
    }

    @Override
    public String getStatistic() {
        return this.statistic;
    }

    @Override
    public EntityStatBlob getOwner() {
        return this.owner;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void decrementStat(int i) {
        this.value -= i;
    }

    @Override
    public void clearArchive() {
    }

    @Override
    public void archive() {
    }

    @Override
    public IStat clone() {
        return new StaticStat(this.getDomain(), this.getWorld(), this.getCategory(), this.getStatistic(), this.getValue());
    }

    public void startTimer() {
        this.timerStarted = System.currentTimeMillis();
    }

    public int getTime() {
        return this.timerStarted > 0L ? (int)((System.currentTimeMillis() - this.timerStarted) / 1000L) : 0;
    }

    public void resetTimer() {
        this.timerStarted = 0L;
    }

    public void markAndResetTimer() {
        this.value += this.getTime();
        this.resetTimer();
    }
}

