/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.bukkit.utils;

import com.tehbeard.beardstat.bukkit.identifier.IdentifierService;
import com.tehbeard.beardstat.containers.EntityStatBlob;
import com.tehbeard.beardstat.listeners.defer.DelegateDecrement;
import com.tehbeard.beardstat.listeners.defer.DelegateIncrement;
import com.tehbeard.beardstat.listeners.defer.DelegateSet;
import com.tehbeard.beardstat.manager.EntityStatManager;
import com.tehbeard.beardstat.utils.deferred.promise.Promise;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

public class StatUtils {
    private static EntityStatManager manager = null;
    public static final StatUtils instance = new StatUtils("default");
    private final String domain;

    public static void setManager(EntityStatManager manager) {
        StatUtils.manager = manager;
    }

    public StatUtils(String domain) {
        this.domain = domain;
    }

    public void modifyStatPotion(Player player, String category, PotionEffect effect, int amount) {
        this.modifyStatPlayer(player, category, IdentifierService.getIdForPotionEffect(effect), amount);
    }

    public void modifyStatEntity(Player player, String category, Entity entity, int amount) {
        this.modifyStatPlayer(player, category, IdentifierService.getIdForEntity(entity), amount);
        if (entity instanceof Skeleton) {
            this.modifyStatPlayer(player, category, ((Skeleton)entity).getSkeletonType().toString().toLowerCase() + "_skeleton", amount);
        }
        if (entity instanceof Zombie && ((Zombie)entity).isVillager()) {
            this.modifyStatPlayer(player, category, "villager_zombie", amount);
        }
    }

    public void setPlayerStat(Player player, String category, String statistic, int amount) {
        this.set(player, player.getWorld().getName(), category, statistic, amount);
    }

    public void modifyStatPlayer(Player player, String category, String statistic, int amount) {
        this.modifyStat(player, player.getWorld().getName(), category, statistic, null, amount);
    }

    public void modifyStatItem(Player player, String category, ItemStack item, int amount) {
        String baseId = IdentifierService.getIdForItemStack(item);
        String metaId = IdentifierService.getIdForItemStackWithMeta(item);
        this.modifyStat(player, player.getWorld().getName(), category, baseId, metaId, amount);
    }

    public void modifyStatBlock(Player player, String category, Block block, int amount) {
        this.modifyStatBlock(player, player.getWorld().getName(), category, block, amount);
    }

    public void modifyStatBlock(Player player, String world, String category, Block block, int amount) {
        String baseId = IdentifierService.getIdForMaterial(block.getType());
        String metaId = IdentifierService.getIdForMaterial(block.getType(), block.getData());
        this.modifyStat(player, world, category, baseId, metaId, amount);
    }

    public void modifyStat(Player player, String world, String category, String baseId, String metaId, int amount) {
        boolean inc = amount > 0;
        int am = Math.abs(amount);
        if (inc) {
            this.increment(player, world, category, baseId, am);
            if (metaId != null) {
                this.increment(player, world, category, metaId, am);
            }
        } else {
            this.decrement(player, world, category, baseId, am);
            if (metaId != null) {
                this.decrement(player, world, category, metaId, am);
            }
        }
    }

    public void increment(Player player, String world, String category, String statistic, int amount) {
        Promise<EntityStatBlob> blob = manager.getPlayer(player.getUniqueId(), player.getName());
        blob.onResolve(new DelegateIncrement(this.domain, world, category, statistic, amount));
    }

    public void decrement(Player player, String world, String category, String statistic, int amount) {
        Promise<EntityStatBlob> blob = manager.getPlayer(player.getUniqueId(), player.getName());
        blob.onResolve(new DelegateDecrement(this.domain, world, category, statistic, amount));
    }

    public void set(Player player, String world, String category, String statistic, int amount) {
        Promise<EntityStatBlob> blob = manager.getPlayer(player.getUniqueId(), player.getName());
        blob.onResolve(new DelegateSet(this.domain, world, category, statistic, amount));
    }
}

