/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.bukkit.commands;

import com.tehbeard.beardstat.BeardStatRuntimeException;
import com.tehbeard.beardstat.LanguagePack;
import com.tehbeard.beardstat.bukkit.BukkitPlugin;
import com.tehbeard.beardstat.bukkit.commands.BeardStatCommand;
import com.tehbeard.beardstat.containers.EntityStatBlob;
import com.tehbeard.beardstat.containers.IStat;
import com.tehbeard.beardstat.containers.StatVector;
import com.tehbeard.beardstat.manager.EntityStatManager;
import com.tehbeard.beardstat.manager.OnlineTimeManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class playedCommand
extends BeardStatCommand {
    public playedCommand(EntityStatManager playerStatManager, BukkitPlugin plugin) {
        super(playerStatManager, plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String cmdLabel, String[] args) {
        try {
            OfflinePlayer selectedPlayer;
            int seconds = 0;
            OfflinePlayer offlinePlayer = selectedPlayer = sender instanceof OfflinePlayer ? (OfflinePlayer)sender : null;
            if (args.length == 1 && sender.hasPermission("stat.command.played.other")) {
                OfflinePlayer offlinePlayer2 = selectedPlayer = Bukkit.getOfflinePlayer((String)args[0]).hasPlayedBefore() ? Bukkit.getOfflinePlayer((String)args[0]) : null;
            }
            if (selectedPlayer == null) {
                sender.sendMessage(ChatColor.RED + LanguagePack.getMsg("command.error.noconsole.noargs"));
                return true;
            }
            EntityStatBlob blob = this.playerStatManager.getPlayer(selectedPlayer.getUniqueId(), selectedPlayer.getName(), false);
            if (blob == null) {
                sender.sendMessage(ChatColor.RED + LanguagePack.getMsg("command.error.noplayer", args[0]));
                return true;
            }
            StatVector vector = blob.getStats("default", "*", "stats", "playedfor");
            seconds = vector.getValue();
            OnlineTimeManager.ManagerRecord onlineTimeRecord = OnlineTimeManager.getRecord(selectedPlayer.getName());
            if (onlineTimeRecord != null) {
                seconds += onlineTimeRecord.sessionTime();
            }
            sender.sendMessage(this.getPlayedString(seconds) + " total");
            for (IStat stat : vector) {
                sender.sendMessage(LanguagePack.getMsg("command.stat.stat", stat.getWorld(), this.getPlayedString(stat.getValue())));
            }
        }
        catch (Exception e) {
            this.plugin.handleError(new BeardStatRuntimeException("An error occured running /played", e, true));
        }
        return true;
    }

    public String getPlayedString(int seconds) {
        if (seconds > 0) {
            return this.playerStatManager.formatStat("playedfor", seconds);
        }
        return LanguagePack.getMsg("command.played.zero");
    }
}

