/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.bukkit.commands;

import com.tehbeard.beardstat.BeardStatRuntimeException;
import com.tehbeard.beardstat.LanguagePack;
import com.tehbeard.beardstat.bukkit.BukkitPlugin;
import com.tehbeard.beardstat.bukkit.commands.BeardStatCommand;
import com.tehbeard.beardstat.containers.EntityStatBlob;
import com.tehbeard.beardstat.manager.EntityStatManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class StatPageCommand
extends BeardStatCommand {
    private final Map<String, StatPage> pages = new HashMap<String, StatPage>();

    public StatPageCommand(EntityStatManager statManager, BukkitPlugin plugin) {
        super(statManager, plugin);
        ConfigurationSection pageConfig = plugin.getConfig().getConfigurationSection("pages");
        if (pageConfig != null) {
            Set pageNames = pageConfig.getKeys(false);
            for (String pageName : pageNames) {
                this.pages.put(pageName, new StatPage(pageConfig.getStringList(pageName)));
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String lbl, String[] args) {
        try {
            EntityStatBlob blob = null;
            if (sender instanceof Player) {
                blob = this.playerStatManager.getPlayer(((Player)sender).getUniqueId(), ((Player)sender).getName(), false);
            }
            if (blob == null && args.length != 2) {
                return false;
            }
            String page = null;
            if (args.length == 2) {
                OfflinePlayer player = Bukkit.getOfflinePlayer((String)args[0]);
                blob = this.playerStatManager.getPlayer(player.getUniqueId(), player.getName(), false);
                page = args[1];
            }
            if (args.length == 1) {
                page = args[0];
            }
            if (page == null) {
                return false;
            }
            StatPage pageFile = this.pages.get(page);
            if (pageFile == null) {
                return false;
            }
            pageFile.toCommandSender(sender, blob);
            return true;
        }
        catch (Exception e) {
            this.plugin.handleError(new BeardStatRuntimeException("/statpage threw an error", e, true));
            return true;
        }
    }

    public class StatPage {
        private List<StatPageEntry> entries = new ArrayList<StatPageEntry>();

        public StatPage(List<String> lines) {
            for (String line : lines) {
                this.entries.add(new StatPageEntry(line));
            }
        }

        public void toCommandSender(CommandSender sender, EntityStatBlob blob) {
            for (StatPageEntry entry : this.entries) {
                entry.toCommandSender(sender, blob);
            }
        }

        public class StatPageEntry {
            public final String label;
            public final String domain;
            public final String world;
            public final String category;
            public final String statistic;

            StatPageEntry(String line) {
                String[] p = line.split("\\:");
                if (p.length != 2) {
                    throw new IllegalArgumentException("Could parse line, invalid number of ':' found.");
                }
                this.label = p[0];
                Stack<String> parts = new Stack<String>();
                for (String s : p[1].split("\\.")) {
                    parts.push(s);
                }
                this.statistic = (String)parts.pop();
                this.category = (String)parts.pop();
                this.world = parts.isEmpty() ? "*" : (String)parts.pop();
                this.domain = parts.isEmpty() ? "default" : (String)parts.pop();
            }

            public void toCommandSender(CommandSender sender, EntityStatBlob blob) {
                int value = blob.getStats(this.domain, this.world, this.category, this.statistic).getValue();
                sender.sendMessage(LanguagePack.getMsg("command.stat.stat", this.label, StatPageCommand.this.playerStatManager.formatStat(this.statistic, value)));
            }
        }
    }
}

