/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.dataproviders.sqlite;

import com.tehbeard.beardstat.dataproviders.sqlite.DocEntry;
import com.tehbeard.beardstat.utils.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DocumentStore {
    @Expose
    Map<String, DocEntry> documents = new HashMap<String, DocEntry>();

    public DocEntry getDocumentData(String domainId, String key) {
        String keyCode = domainId + ":" + key;
        if (!this.documents.containsKey(keyCode)) {
            this.documents.put(keyCode, new DocEntry());
        }
        return this.documents.get(keyCode);
    }

    public String[] getDocsUnderDomain(String domain) {
        ArrayList<String> s = new ArrayList<String>();
        for (String k : this.documents.keySet()) {
            if (!k.startsWith(domain + ":")) continue;
            s.add(k.replaceAll(domain + ":", ""));
        }
        return s.toArray(new String[0]);
    }

    public void deleteDocument(String domain, String key) {
        this.documents.remove(domain + ":" + key);
    }
}

