/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.dataproviders;

import java.util.UUID;

public class ProviderQuery {
    public static final ProviderQuery ALL_PLAYERS = new ProviderQuery(null, "player", null, false);
    public final String name;
    public final String type;
    private final UUID uuid;
    public final boolean create;
    public boolean likeName = false;
    public boolean noNameChk = false;

    public ProviderQuery(UUID player, String name, boolean create) {
        this(name, "player", player, create);
    }

    public ProviderQuery(String name, String type, UUID uuid, boolean create) {
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null.");
        }
        this.name = name;
        this.type = type;
        this.uuid = uuid != null ? uuid : (name != null ? UUID.nameUUIDFromBytes(name.getBytes()) : null);
        this.create = create;
    }

    public ProviderQuery partialNameMatch() {
        this.likeName = true;
        return this;
    }

    public ProviderQuery noNameChk() {
        this.noNameChk = true;
        return this;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 31 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 31 * hash + (this.uuid != null ? this.uuid.hashCode() : 0);
        hash = 31 * hash + (this.create ? 1 : 0);
        hash = 31 * hash + (this.likeName ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProviderQuery other = (ProviderQuery)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid)) {
            return false;
        }
        if (this.create != other.create) {
            return false;
        }
        return this.likeName == other.likeName;
    }

    public ProviderQuery clone() {
        ProviderQuery p = new ProviderQuery(this.name, this.type, this.uuid, this.create);
        p.likeName = this.likeName;
        return p;
    }

    public String toString() {
        return "ProviderQuery [name=" + this.name + ", type=" + this.type + ", uuid=" + this.uuid + ", create=" + this.create + ", likeName=" + this.likeName + "]";
    }

    public String getUUIDString() {
        return this.uuid == null ? null : this.uuid.toString().replaceAll("-", "");
    }

    public UUID getUUID() {
        return this.uuid;
    }
}

