/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.dataproviders;

import com.tehbeard.beardstat.BeardStatRuntimeException;
import com.tehbeard.beardstat.DatabaseConfiguration;
import com.tehbeard.beardstat.DbPlatform;
import com.tehbeard.beardstat.bukkit.identifier.IdentifierService;
import com.tehbeard.beardstat.containers.EntityStatBlob;
import com.tehbeard.beardstat.containers.IStat;
import com.tehbeard.beardstat.containers.StatBlobRecord;
import com.tehbeard.beardstat.containers.documents.docfile.DocumentFile;
import com.tehbeard.beardstat.containers.documents.docfile.DocumentFileRef;
import com.tehbeard.beardstat.dataproviders.DocumentTooLargeException;
import com.tehbeard.beardstat.dataproviders.IStatDataProvider;
import com.tehbeard.beardstat.dataproviders.ProviderQuery;
import com.tehbeard.beardstat.dataproviders.ProviderQueryResult;
import com.tehbeard.beardstat.dataproviders.metadata.CategoryMeta;
import com.tehbeard.beardstat.dataproviders.metadata.DomainMeta;
import com.tehbeard.beardstat.dataproviders.metadata.StatisticMeta;
import com.tehbeard.beardstat.dataproviders.metadata.WorldMeta;
import com.tehbeard.beardstat.utils.sql.DBVersion;
import com.tehbeard.beardstat.utils.sql.JDBCDataSource;
import com.tehbeard.beardstat.utils.sql.PostUpgrade;
import com.tehbeard.beardstat.utils.sql.SQLInitScript;
import com.tehbeard.beardstat.utils.sql.SQLScript;
import com.tehbeard.beardstat.utils.uuid.MojangWebAPI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import java.util.logging.Level;

@SQLInitScript(value="sql/maintenence/create.tables")
public abstract class JDBCStatDataProvider
extends JDBCDataSource
implements IStatDataProvider {
    public static final String SQL_SAVE_ENTITY = "sql/entity/saveEntity";
    public static final String SQL_SAVE_STAT = "sql/entity/saveStat";
    public static final String SQL_LOAD_ENTITY_DATA = "sql/entity/getEntityData";
    public static final String SQL_LOAD_DOMAINS = "sql/components/load/getDomains";
    public static final String SQL_LOAD_WORLDS = "sql/components/load/getWorlds";
    public static final String SQL_LOAD_CATEGORIES = "sql/components/load/getCategories";
    public static final String SQL_LOAD_STATISTICS = "sql/components/load/getStatistics";
    public static final String SQL_SAVE_DOMAIN = "sql/components/save/saveDomain";
    public static final String SQL_SAVE_WORLD = "sql/components/save/saveWorld";
    public static final String SQL_SAVE_CATEGORY = "sql/components/save/saveCategory";
    public static final String SQL_SAVE_STATISTIC = "sql/components/save/saveStatistic";
    public static final String SQL_SAVE_UUID = "sql/save/setUUID";
    public static final String SQL_METADATA_CATEGORY = "sql/maintenence/metadata/category";
    public static final String SQL_METADATA_STATISTIC = "sql/maintenence/metadata/statistic";
    public static final String SQL_METADATA_STATIC_STATS = "sql/maintenence/metadata/staticstats";
    public static final String SQL_METADATA_STATIC_FIXNULL = "sql/maintenence/metadata/fixnull";
    public static final String SQL_KEEP_ALIVE = "sql/maintenence/keepAlive";
    @SQLScript(value="sql/components/load/getDomains")
    protected PreparedStatement loadDomainsList;
    @SQLScript(value="sql/components/load/getWorlds")
    protected PreparedStatement loadWorldsList;
    @SQLScript(value="sql/components/load/getCategories")
    protected PreparedStatement loadCategoriesList;
    @SQLScript(value="sql/components/load/getStatistics")
    protected PreparedStatement loadStatisticsList;
    @SQLScript(value="sql/components/save/saveDomain", flags=1)
    protected PreparedStatement saveDomain;
    @SQLScript(value="sql/components/save/saveWorld", flags=1)
    protected PreparedStatement saveWorld;
    @SQLScript(value="sql/components/save/saveCategory", flags=1)
    protected PreparedStatement saveCategory;
    @SQLScript(value="sql/components/save/saveStatistic", flags=1)
    protected PreparedStatement saveStatistic;
    @SQLScript(value="sql/entity/getEntityData")
    protected PreparedStatement loadEntityData;
    @SQLScript(value="sql/entity/saveEntity")
    protected PreparedStatement saveEntity;
    @SQLScript(value="sql/entity/saveStat")
    protected PreparedStatement saveEntityData;
    @SQLScript(value="sql/maintenence/keepAlive")
    protected PreparedStatement keepAlive;
    protected PreparedStatement deleteEntity;
    @SQLScript(value="sql/save/setUUID")
    protected PreparedStatement setUUID;
    private final Map<String, DomainMeta> domainMetaMap = new HashMap<String, DomainMeta>();
    private final Map<String, WorldMeta> worldMetaMap = new HashMap<String, WorldMeta>();
    private final Map<String, CategoryMeta> categoryMetaMap = new HashMap<String, CategoryMeta>();
    private final Map<String, StatisticMeta> statisticMetaMap = new HashMap<String, StatisticMeta>();
    private HashMap<Integer, StatBlobRecord> writeCache = new HashMap();
    protected DbPlatform platform;
    protected DatabaseConfiguration config;
    private Runnable flush = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap hashMap = JDBCStatDataProvider.this.writeCache;
            synchronized (hashMap) {
                try {
                    JDBCStatDataProvider.this.keepAlive.execute();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (!JDBCStatDataProvider.this.checkConnection()) {
                    JDBCStatDataProvider.this.platform.getLogger().warning("Could not restablish connection, will try again later, WARNING: CACHE WILL GROW WHILE THIS HAPPENS");
                } else {
                    JDBCStatDataProvider.this.platform.getLogger().config("Saving to database");
                    for (Map.Entry entry : JDBCStatDataProvider.this.writeCache.entrySet()) {
                        StatBlobRecord updateRecord = (StatBlobRecord)entry.getValue();
                        IStat stat2 = null;
                        try {
                            JDBCStatDataProvider.this.saveEntityData.clearBatch();
                            for (IStat stat2 : updateRecord.stats) {
                                JDBCStatDataProvider.this.saveEntityData.setInt(1, updateRecord.entityId);
                                JDBCStatDataProvider.this.saveEntityData.setInt(2, JDBCStatDataProvider.this.getDomain(stat2.getDomain(), true).getDbId());
                                JDBCStatDataProvider.this.saveEntityData.setInt(3, JDBCStatDataProvider.this.getWorld(stat2.getWorld(), true).getDbId());
                                JDBCStatDataProvider.this.saveEntityData.setInt(4, JDBCStatDataProvider.this.getCategory(stat2.getCategory(), true).getDbId());
                                JDBCStatDataProvider.this.saveEntityData.setInt(5, JDBCStatDataProvider.this.getStatistic(stat2.getStatistic(), true).getDbId());
                                JDBCStatDataProvider.this.saveEntityData.setInt(6, stat2.getValue());
                                JDBCStatDataProvider.this.saveEntityData.addBatch();
                            }
                            JDBCStatDataProvider.this.saveEntityData.executeBatch();
                            for (DocumentFileRef ref : updateRecord.files) {
                                try {
                                    DocumentFile newDoc = JDBCStatDataProvider.this.pushDocument(updateRecord.entityId, ref.getRef());
                                    ref.getRef().invalidateDocument();
                                    ref.setRef(newDoc);
                                }
                                catch (IStatDataProvider.RevisionMismatchException ex) {
                                    ref.invalidateRef();
                                    JDBCStatDataProvider.this.platform.getLogger().log(Level.SEVERE, "Document {0}:{1} failed to save.", new Object[]{ref.getRef().getDomain(), ref.getRef().getKey()});
                                    JDBCStatDataProvider.this.platform.getLogger().severe("Another process has stored a new revision at this address.");
                                    JDBCStatDataProvider.this.platform.getLogger().severe("No Revision Merge strategy found. Changes not saved.");
                                }
                                catch (DocumentTooLargeException e) {
                                    JDBCStatDataProvider.this.platform.getLogger().log(Level.SEVERE, "Document {0}:{1} failed to save.", new Object[]{ref.getRef().getDomain(), ref.getRef().getKey()});
                                    JDBCStatDataProvider.this.platform.getLogger().severe("The document was too large to save to the database.");
                                }
                            }
                        }
                        catch (SQLException e) {
                            JDBCStatDataProvider.this.platform.getLogger().log(Level.WARNING, "entity id: {0}}", new Object[]{updateRecord.entityId});
                            JDBCStatDataProvider.this.platform.getLogger().log(Level.WARNING, "domain: {0} :: {1}", new Object[]{stat2.getDomain(), JDBCStatDataProvider.this.getDomain(stat2.getDomain(), true).getDbId()});
                            JDBCStatDataProvider.this.platform.getLogger().log(Level.WARNING, "world: {0} :: {1}", new Object[]{stat2.getWorld(), JDBCStatDataProvider.this.getWorld(stat2.getWorld(), true).getDbId()});
                            JDBCStatDataProvider.this.platform.getLogger().log(Level.WARNING, "category: {0} :: {1}", new Object[]{stat2.getCategory(), JDBCStatDataProvider.this.getCategory(stat2.getCategory(), true).getDbId()});
                            JDBCStatDataProvider.this.platform.getLogger().log(Level.WARNING, "statistic: {0} :: {1}", new Object[]{stat2.getStatistic(), JDBCStatDataProvider.this.getStatistic(stat2.getStatistic(), true).getDbId()});
                            JDBCStatDataProvider.this.platform.getLogger().log(Level.WARNING, "Value: {0}", stat2.getValue());
                            JDBCStatDataProvider.this.platform.mysqlError(e, JDBCStatDataProvider.SQL_SAVE_STAT);
                            JDBCStatDataProvider.this.checkConnection();
                        }
                    }
                    JDBCStatDataProvider.this.platform.getLogger().config("Clearing write cache");
                    JDBCStatDataProvider.this.writeCache.clear();
                }
            }
        }
    };
    public static final int MAX_UUID_REQUESTS_PER = 128;

    public Connection getConnection() {
        return this.connection;
    }

    public JDBCStatDataProvider(DbPlatform platform, String scriptSuffix, String driverClass, DatabaseConfiguration config) throws ClassNotFoundException {
        super(scriptSuffix, driverClass, platform.getLogger());
        this.connectionProperties.put("allowMultiQuery", "true");
        this.config = config;
        this.platform = platform;
    }

    protected void initialise() throws BeardStatRuntimeException {
        try {
            this.setup();
            this.executeScript(SQL_METADATA_CATEGORY);
            this.executeScript(SQL_METADATA_STATISTIC);
            this.executeScript(SQL_METADATA_STATIC_STATS);
            this.executeScript(SQL_METADATA_STATIC_FIXNULL);
            this.cacheComponents();
        }
        catch (SQLException e) {
            throw new BeardStatRuntimeException("Failed to initialize database", e, false);
        }
    }

    public void cacheComponents() {
        ResultSet rs;
        try {
            rs = this.loadDomainsList.executeQuery();
            this.domainMetaMap.clear();
            while (rs.next()) {
                DomainMeta dm = new DomainMeta(rs.getInt("domainId"), rs.getString("domain"));
                this.domainMetaMap.put(rs.getString("domain"), dm);
            }
            rs.close();
        }
        catch (SQLException e) {
            this.platform.mysqlError(e, SQL_LOAD_DOMAINS);
        }
        try {
            rs = this.loadWorldsList.executeQuery();
            this.worldMetaMap.clear();
            while (rs.next()) {
                WorldMeta wm = new WorldMeta(rs.getInt("worldId"), rs.getString("world"), rs.getString("name"));
                this.worldMetaMap.put(rs.getString("world"), wm);
            }
            rs.close();
        }
        catch (SQLException e) {
            this.platform.mysqlError(e, SQL_LOAD_WORLDS);
        }
        try {
            rs = this.loadCategoriesList.executeQuery();
            this.categoryMetaMap.clear();
            while (rs.next()) {
                CategoryMeta cm = new CategoryMeta(rs.getInt("categoryId"), rs.getString("category"), rs.getString("statwrapper"));
                this.categoryMetaMap.put(rs.getString("category"), cm);
            }
            rs.close();
        }
        catch (SQLException e) {
            this.platform.mysqlError(e, SQL_LOAD_CATEGORIES);
        }
        try {
            rs = this.loadStatisticsList.executeQuery();
            this.statisticMetaMap.clear();
            while (rs.next()) {
                StatisticMeta sm = new StatisticMeta(rs.getInt("statisticId"), rs.getString("statistic"), rs.getString("name"), StatisticMeta.Formatting.valueOf(rs.getString("formatting")));
                this.statisticMetaMap.put(rs.getString("statistic"), sm);
            }
            rs.close();
        }
        catch (SQLException e) {
            this.platform.mysqlError(e, SQL_LOAD_STATISTICS);
        }
    }

    @Override
    public ProviderQueryResult[] queryDatabase(ProviderQuery query) {
        if ((query.name == null || query.noNameChk) && query.type == null && query.getUUIDString() == null) {
            throw new IllegalStateException("Invalid ProviderQuery passed.");
        }
        String sql = "SELECT `entityId`,`name`,`type`,`uuid` FROM `${PREFIX}_entity` WHERE ";
        boolean addAnd = false;
        if (query.getUUIDString() != null) {
            if (addAnd) {
                sql = sql + "AND ";
            }
            sql = sql + "`uuid`=? ";
            addAnd = true;
        } else if (query.name != null && !query.noNameChk) {
            if (query.likeName) {
                sql = sql + "`name` LIKE ? ";
                addAnd = true;
            } else {
                sql = sql + "`name`=? ";
                addAnd = true;
            }
        }
        if (query.type != null) {
            if (addAnd) {
                sql = sql + "AND ";
            }
            sql = sql + "`type`=? ";
            addAnd = true;
        }
        try {
            PreparedStatement qryStmt = this.connection.prepareStatement(this.processSQL(sql));
            int colId = 1;
            if (query.getUUIDString() != null) {
                qryStmt.setString(colId, query.getUUIDString());
                ++colId;
            } else if (query.name != null) {
                String sqlName = (query.likeName ? "%" : "") + query.name + (query.likeName ? "%" : "");
                qryStmt.setString(colId, sqlName);
                ++colId;
            }
            if (query.type != null) {
                qryStmt.setString(colId, query.type);
                ++colId;
            }
            ResultSet rs = qryStmt.executeQuery();
            ArrayList<ProviderQueryResult> results = new ArrayList<ProviderQueryResult>();
            while (rs.next()) {
                results.add(new ProviderQueryResult(rs.getInt("entityId"), rs.getString("name"), rs.getString("type"), rs.getString("uuid") == null ? null : MojangWebAPI.expandUUID(rs.getString("uuid"))));
            }
            rs.close();
            return results.toArray(new ProviderQueryResult[0]);
        }
        catch (SQLException e) {
            this.platform.mysqlError(e, "AUTOGEN: " + sql);
            return new ProviderQueryResult[0];
        }
    }

    @Override
    public EntityStatBlob pullEntityBlob(ProviderQuery query) {
        try {
            if (!this.checkConnection()) {
                this.platform.getLogger().severe("Database connection error!");
                return null;
            }
            long t1 = new Date().getTime();
            ProviderQueryResult result = this.getSingleEntity(query);
            EntityStatBlob esb = null;
            if (result != null) {
                esb = new EntityStatBlob(result.name, result.dbid, result.type, result.uuid, this);
                this.loadEntityData.setInt(1, esb.getEntityID());
                ResultSet rs = this.loadEntityData.executeQuery();
                while (rs.next()) {
                    IStat ps = esb.getStat(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4));
                    ps.setValue(rs.getInt(5));
                    ps.clearArchive();
                }
                rs.close();
            } else if (result == null && query.create) {
                this.saveEntity.setString(1, query.name);
                this.saveEntity.setString(2, query.type);
                this.saveEntity.setString(3, query.getUUIDString());
                this.saveEntity.executeUpdate();
                ResultSet rs = this.saveEntity.getGeneratedKeys();
                rs.next();
                esb = new EntityStatBlob(query.name, rs.getInt(1), query.type, query.getUUID(), this);
                rs.close();
            }
            if (esb == null) {
                return null;
            }
            this.platform.loadEvent(esb);
            this.platform.getLogger().log(Level.CONFIG, "time taken to retrieve: {0} Milliseconds", new Date().getTime() - t1);
            return esb;
        }
        catch (SQLException e) {
            this.platform.mysqlError(e, SQL_LOAD_ENTITY_DATA);
            return null;
        }
    }

    protected ProviderQueryResult getSingleEntity(ProviderQuery query) throws IllegalStateException {
        ProviderQueryResult[] results = this.queryDatabase(query);
        if (results.length > 1) {
            throw new IllegalStateException("Invalid Query provided, more than one entity returned.");
        }
        return results.length == 1 ? results[0] : null;
    }

    @Override
    public boolean hasEntityBlob(ProviderQuery query) {
        return this.queryDatabase(query).length > 1;
    }

    @Override
    public boolean deleteEntityBlob(EntityStatBlob blob) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushEntityBlob(EntityStatBlob player) {
        HashMap<Integer, StatBlobRecord> hashMap = this.writeCache;
        synchronized (hashMap) {
            StatBlobRecord copy = player.cloneForArchive();
            if (!this.writeCache.containsKey(player.getName())) {
                this.writeCache.put(copy.entityId, copy);
            }
        }
    }

    @Override
    public void flushSync() {
        this.platform.getLogger().info("Flushing in main thread! Game will lag!");
        this.flush.run();
        this.platform.getLogger().info("Flushed!");
    }

    @Override
    public void flush() {
        new Thread(this.flush).start();
    }

    @Override
    public DomainMeta getDomain(String gameTag, boolean create) {
        String qGameTag = this.sanitizeTag(gameTag);
        if (!this.domainMetaMap.containsKey(qGameTag) && create) {
            try {
                this.saveDomain.setString(1, qGameTag);
                this.saveDomain.execute();
                ResultSet rs = this.saveDomain.getGeneratedKeys();
                rs.next();
                this.domainMetaMap.put(gameTag, new DomainMeta(rs.getInt(1), gameTag));
                rs.close();
            }
            catch (SQLException ex) {
                this.platform.mysqlError(ex, SQL_SAVE_DOMAIN);
            }
        }
        return this.domainMetaMap.get(qGameTag);
    }

    @Override
    public WorldMeta getWorld(String gameTag, boolean create) {
        if (!this.worldMetaMap.containsKey(gameTag) && create) {
            try {
                this.saveWorld.setString(1, gameTag);
                this.saveWorld.setString(2, gameTag.replaceAll("_", " "));
                this.saveWorld.execute();
                ResultSet rs = this.saveWorld.getGeneratedKeys();
                rs.next();
                this.worldMetaMap.put(gameTag, new WorldMeta(rs.getInt(1), gameTag, gameTag.replaceAll("_", " ")));
                rs.close();
            }
            catch (SQLException ex) {
                this.platform.mysqlError(ex, "sql/components/save/saveWorld @ " + gameTag + " cache size: " + this.worldMetaMap.size());
            }
        }
        return this.worldMetaMap.get(gameTag);
    }

    @Override
    public CategoryMeta getCategory(String gameTag, boolean create) {
        if (!this.categoryMetaMap.containsKey(gameTag) && create) {
            try {
                this.saveCategory.setString(1, gameTag);
                this.saveCategory.execute();
                ResultSet rs = this.saveCategory.getGeneratedKeys();
                rs.next();
                this.categoryMetaMap.put(gameTag, new CategoryMeta(rs.getInt(1), gameTag, gameTag.replaceAll("_", " ")));
                rs.close();
            }
            catch (SQLException ex) {
                this.platform.mysqlError(ex, SQL_SAVE_CATEGORY);
            }
        }
        return this.categoryMetaMap.get(gameTag);
    }

    @Override
    public StatisticMeta getStatistic(String gameTag, boolean create) {
        if (gameTag == null) {
            throw new NullPointerException();
        }
        if (!this.statisticMetaMap.containsKey(gameTag) && create) {
            try {
                this.saveStatistic.setString(1, gameTag);
                this.saveStatistic.setString(2, IdentifierService.getHumanName(gameTag));
                this.saveStatistic.setString(3, StatisticMeta.Formatting.none.toString().toLowerCase());
                this.saveStatistic.execute();
                ResultSet rs = this.saveStatistic.getGeneratedKeys();
                rs.next();
                this.statisticMetaMap.put(gameTag, new StatisticMeta(rs.getInt(1), gameTag, gameTag.replaceAll("_", " "), StatisticMeta.Formatting.none));
                rs.close();
            }
            catch (SQLException ex) {
                this.platform.mysqlError(ex, SQL_SAVE_STATISTIC);
            }
        }
        return this.statisticMetaMap.get(gameTag);
    }

    private String sanitizeTag(String gameTag) {
        String truncatedName = gameTag.toLowerCase();
        if (truncatedName.length() > 64) {
            truncatedName = truncatedName.substring(0, 64);
        }
        return truncatedName;
    }

    @PostUpgrade
    @DBVersion(value=6)
    public void upgradeWriteUUIDS() throws SQLException, Exception {
        this.platform.getLogger().log(Level.INFO, "Updating all UUIDs based on Mojang Web API");
        PreparedStatement stmt = this.connection.prepareStatement(this.processSQL("UPDATE `${PREFIX}_entity` SET `uuid`=? WHERE `name`=? and `type`=?"));
        stmt.setString(3, "player");
        this.platform.getLogger().log(Level.INFO, "Generating list of players to checks");
        ProviderQueryResult[] result = this.queryDatabase(ProviderQuery.ALL_PLAYERS);
        ArrayList<String> toGet = new ArrayList<String>(result.length);
        for (ProviderQueryResult res : result) {
            toGet.add(res.name);
        }
        this.platform.getLogger().log(Level.INFO, "Querying Mojang Web API");
        Map<String, UUID> map = MojangWebAPI.lookupUUIDS(toGet);
        this.platform.getLogger().log(Level.INFO, "Applying Name->UUID mapping.");
        for (Map.Entry<String, UUID> e : map.entrySet()) {
            stmt.setString(2, e.getKey());
            stmt.setString(1, e.getValue().toString().replaceAll("-", ""));
            stmt.executeUpdate();
        }
        this.platform.getLogger().log(Level.INFO, "Updated {0} entries", map.size());
    }

    public String readSQLFile(String type, String filename) {
        this.platform.getLogger().fine("Loading SQL: " + filename);
        InputStream is = this.platform.getResource(filename + "." + type);
        if (is == null) {
            is = this.platform.getResource(filename + ".sql");
        }
        if (is == null) {
            throw new IllegalArgumentException("No SQL file found with name " + filename + "." + this.scriptSuffix);
        }
        Scanner scanner = new Scanner(is);
        String sql = scanner.useDelimiter("\\Z").next().replaceAll("\\Z", "").replaceAll("\\n|\\r", "");
        scanner.close();
        return this.processSQL(sql);
    }

    public String byteArrayToHexString(byte[] b) {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    @Override
    public void setUUID(String player, String uuid) {
        try {
            this.setUUID.setString(1, uuid);
            this.setUUID.setString(2, player);
            this.setUUID.setString(3, "player");
            this.setUUID.executeUpdate();
        }
        catch (SQLException e) {
            this.platform.mysqlError(e, SQL_SAVE_UUID);
        }
    }

    public void runExternalScript(File file) throws SQLException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (is == null) {
            return;
        }
        Scanner scanner = new Scanner(is);
        String sql = scanner.useDelimiter("\\Z").next().replaceAll("\\Z", "").replaceAll("\\n|\\r", "");
        scanner.close();
        this.connection.prepareStatement(this.processSQL(sql)).execute();
    }

    @Override
    protected String getMigrationScriptPath(int toVersion) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getDataSourceVersion() {
        return Integer.parseInt("${project.database.version}");
    }
}

