/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.containers.documents.docfile;

import com.tehbeard.beardstat.containers.EntityStatBlob;
import com.tehbeard.beardstat.containers.documents.IStatDocument;
import com.tehbeard.beardstat.containers.documents.IStatDynamicDocument;
import java.sql.Timestamp;

public class DocumentFile {
    private boolean archive = false;
    private final String revision;
    private final String parentRevision;
    private final String domain;
    private final String key;
    private final IStatDocument document;
    private final Timestamp dateCreated;
    private boolean isInvalid = false;
    private EntityStatBlob owner = null;

    public DocumentFile(String domain, String key, IStatDocument document) {
        this(null, null, domain, key, document, null);
    }

    public DocumentFile(String revision, String parentRevision, String domain, String key, IStatDocument document, Timestamp dateCreated) {
        this.revision = revision;
        this.parentRevision = parentRevision;
        this.domain = domain;
        this.key = key;
        this.document = document;
        this.dateCreated = dateCreated;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getKey() {
        return this.key;
    }

    public Timestamp getDateCreated() {
        return this.dateCreated;
    }

    public boolean shouldArchive() {
        return this.archive || this.document instanceof IStatDynamicDocument;
    }

    public void setArchiveFlag() {
        this.archive = true;
    }

    public void clearArchiveFlag() {
        this.archive = false;
    }

    public String getParentRevision() {
        return this.parentRevision;
    }

    public <T extends IStatDocument> T getDocument() {
        if (this.document instanceof IStatDynamicDocument) {
            ((IStatDynamicDocument)this.document).updateDocument(this.getOwner());
        }
        return (T)this.document;
    }

    public synchronized boolean isInvalid() {
        return this.isInvalid;
    }

    public synchronized void invalidateDocument() {
        this.isInvalid = true;
    }

    public EntityStatBlob getOwner() {
        return this.owner;
    }

    public void setOwner(EntityStatBlob owner) {
        this.owner = owner;
    }
}

