/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.containers.documents;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class DocumentHistory {
    private final List<DocumentHistoryEntry> entries = new ArrayList<DocumentHistoryEntry>();
    private final String domain;
    private final String key;
    private final String latestRevision;

    public DocumentHistory(String domain, String key, String latestRevision) {
        this.domain = domain;
        this.key = key;
        this.latestRevision = latestRevision;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getKey() {
        return this.key;
    }

    public List<DocumentHistoryEntry> getEntries() {
        return this.entries;
    }

    public DocumentHistoryEntry getLatestEntry() {
        return this.getEntry(this.latestRevision);
    }

    public String getHeadRevision() {
        return this.latestRevision;
    }

    public DocumentHistoryEntry getEntry(String revisionId) {
        for (DocumentHistoryEntry e : this.entries) {
            if (!e.revision.equals(revisionId)) continue;
            return e;
        }
        return null;
    }

    public void addEntry(String revision, String parentRev, Timestamp added) {
        this.entries.add(new DocumentHistoryEntry(revision, parentRev, added));
    }

    public class DocumentHistoryEntry {
        private final String revision;
        private final String parentRev;
        private final Timestamp added;

        public String getRevision() {
            return this.revision;
        }

        public String getParentRev() {
            return this.parentRev;
        }

        public Timestamp getAdded() {
            return this.added;
        }

        public DocumentHistoryEntry(String revision, String parentRev, Timestamp added) {
            this.revision = revision;
            this.parentRev = parentRev;
            this.added = added;
        }

        public DocumentHistoryEntry getParent() {
            return DocumentHistory.this.getEntry(this.parentRev);
        }
    }
}

