/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.containers;

import com.tehbeard.beardstat.containers.EntityStatBlob;
import com.tehbeard.beardstat.containers.IStat;

public class StaticStat
implements IStat {
    EntityStatBlob owner = null;
    private String domain;
    private String world;
    private String category = "stats";
    private String statistic;
    private int value;
    private boolean archive = false;

    public StaticStat(String domain, String world, String cat, String statistic, int value) {
        if (statistic == null) {
            throw new IllegalArgumentException("Passed null statistic");
        }
        this.domain = domain;
        this.world = world;
        this.statistic = statistic;
        this.value = value;
        this.category = cat;
    }

    @Override
    public synchronized int getValue() {
        return this.value;
    }

    @Override
    public synchronized void setValue(int value) {
        this.changeValue(value);
    }

    @Override
    public String getStatistic() {
        return this.statistic;
    }

    @Override
    public synchronized void incrementStat(int i) {
        this.changeValue(this.value + i);
    }

    @Override
    public synchronized void decrementStat(int i) {
        this.changeValue(this.value - i);
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public synchronized void clearArchive() {
        this.archive = false;
    }

    @Override
    public synchronized boolean isArchive() {
        return this.archive;
    }

    @Override
    public EntityStatBlob getOwner() {
        return this.owner;
    }

    private synchronized void changeValue(int to) {
        this.value = to;
        this.archive = true;
    }

    @Override
    public void setOwner(EntityStatBlob playerStatBlob) {
        this.owner = playerStatBlob;
    }

    public String toString() {
        return this.category + "." + this.statistic + "=" + this.value;
    }

    @Override
    public synchronized void archive() {
        this.archive = true;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public void setWorld(String world) {
        this.world = world;
    }

    @Override
    public String getWorld() {
        return this.world;
    }

    @Override
    public IStat clone() {
        return new StaticStat(this.domain, this.world, this.category, this.statistic, this.value);
    }
}

