/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.containers;

import com.tehbeard.beardstat.containers.IStat;
import com.tehbeard.beardstat.containers.StatBlobRecord;
import com.tehbeard.beardstat.containers.StatVector;
import com.tehbeard.beardstat.containers.StaticStat;
import com.tehbeard.beardstat.containers.documents.IStatDocument;
import com.tehbeard.beardstat.containers.documents.docfile.DocumentFile;
import com.tehbeard.beardstat.containers.documents.docfile.DocumentFileRef;
import com.tehbeard.beardstat.dataproviders.IStatDataProvider;
import com.tehbeard.beardstat.utils.expressions.VariableProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class EntityStatBlob
implements VariableProvider {
    private Map<String, IStat> stats = new ConcurrentHashMap<String, IStat>();
    private int entityId;
    private String name;
    private String type;
    private UUID uuid;
    private IStatDataProvider provider;
    private Map<String, DocumentFileRef> files = new HashMap<String, DocumentFileRef>();

    public String getName() {
        return this.name;
    }

    public int getEntityID() {
        return this.entityId;
    }

    public EntityStatBlob(String name, int entityId, String type, UUID uuid, IStatDataProvider provider) {
        Logger.getGlobal().info("Created EntityStatBlob");
        this.name = name;
        this.entityId = entityId;
        this.type = type;
        this.uuid = uuid;
        this.provider = provider;
    }

    public void addStat(IStat stat) {
        this.stats.put(stat.getDomain() + "::" + stat.getWorld() + "::" + stat.getCategory() + "::" + stat.getStatistic(), stat);
        stat.setOwner(this);
    }

    public IStat getStat(String world, String category, String statistic) {
        return this.getStat("default", world, category, statistic);
    }

    public IStat getStat(String domain, String world, String category, String statistic) {
        IStat psn = this.stats.get(domain + "::" + world + "::" + category + "::" + statistic);
        if (psn != null) {
            return psn;
        }
        psn = new StaticStat(domain, world, category, statistic, 0);
        this.addStat(psn);
        return psn;
    }

    public StatVector getStats(String domain, String world, String category, String statistic) {
        return this.getStats(domain, world, category, statistic, true);
    }

    public StatVector getStats(String domain, String world, String category, String statistic, boolean readOnly) {
        String pattern = this.starToRegex(domain);
        pattern = pattern + "\\::" + this.starToRegex(world);
        pattern = pattern + "\\::" + this.starToRegex(category);
        pattern = pattern + "\\::" + this.starToRegex(statistic);
        return this.getStats(domain, world, category, statistic, pattern, readOnly);
    }

    public StatVector getStats(String domain, String world, String category, String statistic, String regex, boolean readOnly) {
        StatVector vector = new StatVector(domain, world, category, statistic, readOnly);
        for (Map.Entry<String, IStat> e : this.stats.entrySet()) {
            if (!Pattern.matches(regex, e.getKey())) continue;
            vector.add(e.getValue());
        }
        return vector;
    }

    private String starToRegex(String s) {
        if (s.equals("*")) {
            return "[a-zA-Z0-9_]*";
        }
        return s;
    }

    public Collection<IStat> getStats() {
        return this.stats.values();
    }

    public boolean hasStat(String domain, String world, String category, String statistic) {
        return this.stats.containsKey(domain + "::" + world + "::" + category + "::" + statistic);
    }

    @Override
    public int resolveVariable(String var) {
        String[] parts = var.split("\\::");
        String domain = "default";
        String world = "*";
        String cat = "";
        String stat = "";
        if (parts.length == 4) {
            domain = parts[0];
            world = parts[1];
            cat = parts[2];
            stat = parts[3];
        }
        if (parts.length != 2) {
            throw new IllegalStateException("Attempt to parse invalid varriable " + var);
        }
        cat = parts[0];
        stat = parts[1];
        return this.getStats(domain, world, cat, stat).getValue();
    }

    public String getType() {
        return this.type;
    }

    public StatBlobRecord cloneForArchive() {
        StatBlobRecord record = new StatBlobRecord(this.entityId);
        for (IStat stat : this.stats.values()) {
            IStat is;
            if (!stat.isArchive() || (is = stat.clone()) == null) continue;
            record.stats.add(is);
            stat.clearArchive();
        }
        for (DocumentFileRef ref : this.files.values()) {
            if (!ref.getRef().shouldArchive()) continue;
            record.files.add(ref);
            ref.getRef().clearArchiveFlag();
        }
        return record;
    }

    @Override
    public int[] resolveReference(String array) {
        throw new UnsupportedOperationException("Array support not yet available.");
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public DocumentFile getDocument(String domain, String key, Class<? extends IStatDocument> docClass) {
        String code = domain + "::" + key;
        if (!this.files.containsKey(code)) {
            DocumentFile docFile = this.provider.pullDocument(this.entityId, domain, key);
            if (docFile == null) {
                if (docClass == null) {
                    return null;
                }
                try {
                    IStatDocument newDoc = docClass.newInstance();
                    docFile = new DocumentFile(domain, key, newDoc);
                }
                catch (InstantiationException ex) {
                    Logger.getLogger(EntityStatBlob.class.getName()).log(Level.SEVERE, null, ex);
                    return null;
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(EntityStatBlob.class.getName()).log(Level.SEVERE, null, ex);
                    return null;
                }
            }
            this.files.put(code, new DocumentFileRef(docFile));
        }
        if (this.files.get(code).isInvalid()) {
            this.files.put(code, new DocumentFileRef(this.provider.pullDocument(this.entityId, domain, key)));
        }
        DocumentFile d = this.files.get(code).getRef();
        d.setOwner(this);
        return d;
    }
}

