/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.bukkit.commands;

import com.tehbeard.beardstat.BeardStatRuntimeException;
import com.tehbeard.beardstat.LanguagePack;
import com.tehbeard.beardstat.bukkit.BukkitPlugin;
import com.tehbeard.beardstat.bukkit.commands.ArgumentPack;
import com.tehbeard.beardstat.bukkit.commands.BeardStatCommand;
import com.tehbeard.beardstat.containers.EntityStatBlob;
import com.tehbeard.beardstat.containers.IStat;
import com.tehbeard.beardstat.containers.StatVector;
import com.tehbeard.beardstat.manager.EntityStatManager;
import java.util.Stack;
import java.util.regex.PatternSyntaxException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StatCommand
extends BeardStatCommand {
    public StatCommand(EntityStatManager playerStatManager, BukkitPlugin plugin) {
        super(playerStatManager, plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String cmdLabel, String[] args) {
        block15: {
            try {
                ArgumentPack arguments = new ArgumentPack(new String[]{"i", "h"}, new String[]{"p", "s"}, args);
                Player player = null;
                if (sender.hasPermission("stat.command.stat.other") && arguments.getOption("p") != null) {
                    player = Bukkit.getOfflinePlayer((String)arguments.getOption("p"));
                }
                if (player == null && sender instanceof Player) {
                    player = (Player)sender;
                }
                if (player == null || arguments.getFlag("h")) {
                    StatCommand.sendHelpMessage(sender);
                    return true;
                }
                if (arguments.getFlag("i")) {
                    sender.sendMessage("Interactive mode has been removed at this time.");
                    return true;
                }
                if (arguments.getOption("s") != null) {
                    Stack<String> stat = new Stack<String>();
                    for (String s : arguments.getOption("s").split("\\:\\:")) {
                        stat.add(s);
                    }
                    String statistic = !stat.isEmpty() ? (String)stat.pop() : null;
                    String category = !stat.isEmpty() ? (String)stat.pop() : null;
                    String world = !stat.isEmpty() ? (String)stat.pop() : ".*";
                    String domain = !stat.isEmpty() ? (String)stat.pop() : ".*";
                    EntityStatBlob blob = this.playerStatManager.getPlayer(player.getUniqueId(), player.getName(), false);
                    sender.sendMessage(ChatColor.YELLOW + "=========");
                    if (blob == null) {
                        sender.sendMessage(LanguagePack.getMsg("command.error.noplayer", player));
                        return true;
                    }
                    StatVector vector = null;
                    try {
                        vector = blob.getStats(domain, world, category, statistic, true);
                    }
                    catch (PatternSyntaxException ex) {
                        sender.sendMessage("Invalid stat entered");
                        return true;
                    }
                    if (vector.size() == 0) {
                        sender.sendMessage(LanguagePack.getMsg("command.error.nostat"));
                        return true;
                    }
                    if (vector.size() == 1) {
                        IStat iStat = vector.iterator().next();
                        sender.sendMessage(LanguagePack.getMsg("command.stat.stat", this.playerStatManager.getLocalizedStatisticName(iStat.getStatistic()), this.playerStatManager.formatStat(iStat.getStatistic(), iStat.getValue())));
                        return true;
                    }
                    if (vector.size() > 1) {
                        sender.sendMessage(LanguagePack.getMsg("command.stat.stat", this.playerStatManager.getLocalizedStatisticName(vector.getStatistic()) + " total", this.playerStatManager.formatStat(vector.getStatistic(), vector.getValue())));
                        for (IStat iStat : vector) {
                            sender.sendMessage(LanguagePack.getMsg("command.stat.stat.world", iStat.getWorld(), iStat.getCategory(), this.playerStatManager.getLocalizedStatisticName(iStat.getStatistic()), this.playerStatManager.formatStat(iStat.getStatistic(), iStat.getValue())));
                        }
                        return true;
                    }
                    break block15;
                }
                sender.sendMessage(ChatColor.YELLOW + "=========");
                Bukkit.dispatchCommand((CommandSender)sender, (String)("statpage " + player.getName() + " default"));
            }
            catch (Exception e) {
                this.plugin.handleError(new BeardStatRuntimeException("/stats threw an error", e, true));
            }
        }
        return true;
    }

    public static void sendHelpMessage(CommandSender sender) {
        sender.sendMessage(ChatColor.BLUE + "Stats Help page");
        sender.sendMessage(ChatColor.BLUE + "/stats:" + ChatColor.GOLD + " Default display of your stats");
        sender.sendMessage(ChatColor.BLUE + "/stats [flags]:");
        sender.sendMessage(ChatColor.BLUE + "-h :" + ChatColor.GOLD + " This page");
        sender.sendMessage(ChatColor.BLUE + "-p [player]:" + ChatColor.GOLD + " view [player]'s stats");
        sender.sendMessage(ChatColor.BLUE + "-s [stat] :" + ChatColor.GOLD + " view this stat (format category::statistic)");
        sender.sendMessage(ChatColor.BLUE + "/statpage :" + ChatColor.GOLD + " list available stat pages");
        sender.sendMessage(ChatColor.BLUE + "/statpage [user] page :" + ChatColor.GOLD + " show a specific stat page");
        if (sender.hasPermission("command.laston")) {
            sender.sendMessage(ChatColor.BLUE + "/laston [user] :" + ChatColor.GOLD + " show when you [or user] was last on");
        }
        if (sender.hasPermission("command.laston")) {
            sender.sendMessage(ChatColor.BLUE + "/firston [user] :" + ChatColor.GOLD + " show when you [or user] was first on");
        }
        if (sender.hasPermission("command.played")) {
            sender.sendMessage(ChatColor.BLUE + "/played [user] :" + ChatColor.GOLD + " shows how long you [or user] have played");
        }
    }
}

