/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.bukkit.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArgumentPack<T> {
    private Set<String> boolFlags;
    private Map<String, String> flagOptions;
    private List<String> strArgs;
    private T sender;

    public T getSender() {
        return this.sender;
    }

    public ArgumentPack(T sender, String[] boolFlags, String[] flagOpts, String[] rawArguments) {
        this(boolFlags, flagOpts, rawArguments);
        this.sender = sender;
    }

    public ArgumentPack(String[] boolFlags, String[] flagOpts, String[] rawArguments) {
        this.initialise(boolFlags, flagOpts, rawArguments);
    }

    public ArgumentPack(String[] boolFlags, String[] flagOpts, String rawArguments) {
        this.initialise(boolFlags, flagOpts, rawArguments.split(" "));
    }

    private void initialise(String[] boolFlags, String[] flagOpts, String[] rawArguments) {
        this.strArgs = new ArrayList<String>();
        this.boolFlags = new HashSet<String>();
        this.flagOptions = new HashMap<String, String>();
        boolean inQuotes = false;
        StringBuilder token = new StringBuilder();
        ArrayList<String> tokens = new ArrayList<String>();
        for (String rawArg : rawArguments) {
            boolean hasQuote;
            boolean bl = hasQuote = rawArg.startsWith("\"") || rawArg.endsWith("\"");
            if (token.length() > 0 && !inQuotes) {
                tokens.add(token.toString().trim());
                token = new StringBuilder();
            }
            if (rawArg.startsWith("\"")) {
                token.append(rawArg.substring(1));
            } else if (rawArg.endsWith("\"")) {
                if (inQuotes && token.length() > 0) {
                    token.append(" ");
                }
                token.append(rawArg.substring(0, rawArg.length() - 1));
            } else {
                if (inQuotes && token.length() > 0) {
                    token.append(" ");
                }
                token.append(rawArg);
            }
            if (!hasQuote) continue;
            inQuotes = !inQuotes;
        }
        if (token.length() > 0) {
            tokens.add(token.toString().trim());
        }
        Iterator it = tokens.iterator();
        while (it.hasNext()) {
            String tok = (String)it.next();
            if (tok.startsWith("-")) {
                String t = tok.substring(1);
                if (this.inArray(boolFlags, t)) {
                    this.boolFlags.add(t);
                    continue;
                }
                if (this.inArray(flagOpts, t)) {
                    if (!it.hasNext()) continue;
                    this.flagOptions.put(t, (String)it.next());
                    continue;
                }
            }
            this.strArgs.add(tok);
        }
    }

    private boolean inArray(String[] arr, String search) {
        for (String a : arr) {
            if (!a.equalsIgnoreCase(search)) continue;
            return true;
        }
        return false;
    }

    public boolean getFlag(String flag) {
        return this.boolFlags.contains(flag);
    }

    public String getOption(String flag) {
        return this.flagOptions.get(flag);
    }

    public int size() {
        return this.strArgs.size();
    }

    public String get(int index) {
        return this.strArgs.get(index);
    }

    public Number getNumber(int index) {
        return Double.parseDouble(this.get(index));
    }
}

