/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.manager;

import com.tehbeard.beardstat.BeardStatRuntimeException;
import com.tehbeard.beardstat.DbPlatform;
import com.tehbeard.beardstat.containers.EntityStatBlob;
import com.tehbeard.beardstat.dataproviders.IStatDataProvider;
import com.tehbeard.beardstat.dataproviders.ProviderQuery;
import com.tehbeard.beardstat.dataproviders.ProviderQueryResult;
import com.tehbeard.beardstat.dataproviders.metadata.StatisticMeta;
import com.tehbeard.beardstat.manager.ASyncLoadBlob;
import com.tehbeard.beardstat.manager.OnlineTimeManager;
import com.tehbeard.beardstat.utils.deferred.promise.Deferred;
import com.tehbeard.beardstat.utils.deferred.promise.Promise;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;

public class EntityStatManager {
    private final Map<UUID, Promise<EntityStatBlob>> uuidCache = new HashMap<UUID, Promise<EntityStatBlob>>();
    private final DbPlatform platform;
    private final IStatDataProvider backendDatabase;
    private ExecutorService loadQueue = Executors.newSingleThreadExecutor();

    public EntityStatManager(DbPlatform platform, IStatDataProvider backendDatabase) {
        this.platform = platform;
        this.backendDatabase = backendDatabase;
    }

    public Promise<EntityStatBlob> getPlayer(UUID player, String name) {
        return this.getPlayerAsync(player, name, true);
    }

    public Promise<EntityStatBlob> getPlayerAsync(UUID player, String name, boolean create) {
        return this.get(new ProviderQuery(player, name, create).noNameChk());
    }

    public EntityStatBlob getPlayer(UUID player, String name, boolean create) {
        try {
            return this.getPlayerAsync(player, name, create).getValue();
        }
        catch (Exception e) {
            this.platform.handleError(new BeardStatRuntimeException("An error occured loading a stat blob for " + player.toString(), e, true));
            return null;
        }
    }

    public Promise<EntityStatBlob> get(ProviderQuery query) {
        if (!this.uuidCache.containsKey(query.getUUID())) {
            Deferred<EntityStatBlob> promise = new Deferred<EntityStatBlob>();
            this.uuidCache.put(query.getUUID(), promise);
            this.loadQueue.submit(new ASyncLoadBlob(query, this.backendDatabase, promise));
        }
        return this.uuidCache.get(query.getUUID());
    }

    public ProviderQueryResult[] queryDatabase(ProviderQuery providerQuery) {
        return this.backendDatabase.queryDatabase(providerQuery);
    }

    public void saveCache() {
        for (Promise<EntityStatBlob> blobP : this.uuidCache.values()) {
            if (!blobP.isResolved()) continue;
            EntityStatBlob blob = blobP.getValue();
            if (blob.getType().equals("player")) {
                String entityName = blob.getName();
                OnlineTimeManager.ManagerRecord timeRecord = OnlineTimeManager.getRecord(entityName);
                if (timeRecord != null) {
                    this.platform.getLogger().log(Level.FINE, "saving time: [Player : {0} , world: {1}, time: {2}]", new Object[]{entityName, timeRecord.world, timeRecord.sessionTime()});
                    if (timeRecord.world != null) {
                        blob.getStat("default", timeRecord.world, "stats", "playedfor").incrementStat(timeRecord.sessionTime());
                    }
                }
                if (this.isPlayerOnline(entityName)) {
                    OnlineTimeManager.setRecord(entityName, this.platform.getWorldForPlayer(entityName));
                } else {
                    OnlineTimeManager.wipeRecord(entityName);
                    this.uuidCache.remove(blob.getUUID());
                }
            }
            this.backendDatabase.pushEntityBlob(blob);
        }
    }

    private boolean isPlayerOnline(String player) {
        return this.platform.isPlayerOnline(player);
    }

    public String getLocalizedStatisticName(String gameTag) {
        StatisticMeta meta = this.backendDatabase.getStatistic(gameTag, false);
        if (meta != null) {
            return meta.getLocalizedName();
        }
        return gameTag;
    }

    public String formatStat(String gameTag, int value) {
        StatisticMeta meta = this.backendDatabase.getStatistic(gameTag, false);
        if (meta != null) {
            return meta.formatStat(value);
        }
        return "" + value;
    }

    public void flush() {
        this.backendDatabase.flush();
    }
}

