/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.dataproviders;

import com.tehbeard.beardstat.BeardStatRuntimeException;
import com.tehbeard.beardstat.DatabaseConfiguration;
import com.tehbeard.beardstat.DbPlatform;
import com.tehbeard.beardstat.containers.documents.DocumentHistory;
import com.tehbeard.beardstat.containers.documents.DocumentRegistry;
import com.tehbeard.beardstat.containers.documents.IStatDocument;
import com.tehbeard.beardstat.containers.documents.StatDocument;
import com.tehbeard.beardstat.containers.documents.docfile.DocumentFile;
import com.tehbeard.beardstat.dataproviders.DocumentTooLargeException;
import com.tehbeard.beardstat.dataproviders.IStatDataProvider;
import com.tehbeard.beardstat.dataproviders.JDBCStatDataProvider;
import com.tehbeard.beardstat.utils.gson.stream.JsonReader;
import com.tehbeard.beardstat.utils.sql.SQLScript;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;

public class MysqlStatDataProvider
extends JDBCStatDataProvider {
    public static final String SQL_DOC_META_INSERT = "sql/doc/meta/metaInsert";
    public static final String SQL_DOC_META_UPDATE = "sql/doc/meta/metaUpdate";
    public static final String SQL_DOC_META_DELETE = "sql/doc/meta/metaDelete";
    public static final String SQL_DOC_META_SELECT = "sql/doc/meta/metaSelect";
    public static final String SQL_DOC_META_POLL = "sql/doc/meta/metaPoll";
    public static final String SQL_DOC_STORE_INSERT = "sql/doc/store/storeInsert";
    public static final String SQL_DOC_STORE_SELECT = "sql/doc/store/storeSelect";
    public static final String SQL_DOC_STORE_POLL = "sql/doc/store/storePoll";
    public static final String SQL_DOC_STORE_DELETE = "sql/doc/store/storeDelete";
    public static final String SQL_DOC_STORE_PURGE = "sql/doc/store/storePurge";
    @SQLScript(value="sql/doc/meta/metaInsert", flags=1)
    private PreparedStatement stmtMetaInsert;
    @SQLScript(value="sql/doc/meta/metaUpdate")
    private PreparedStatement stmtMetaUpdate;
    @SQLScript(value="sql/doc/meta/metaDelete")
    private PreparedStatement stmtMetaDelete;
    @SQLScript(value="sql/doc/meta/metaSelect")
    private PreparedStatement stmtMetaSelect;
    @SQLScript(value="sql/doc/meta/metaPoll")
    private PreparedStatement stmtMetaPoll;
    @SQLScript(value="sql/doc/store/storeInsert", flags=1)
    private PreparedStatement stmtDocInsert;
    @SQLScript(value="sql/doc/store/storeSelect")
    private PreparedStatement stmtDocSelect;
    @SQLScript(value="sql/doc/store/storePoll")
    private PreparedStatement stmtDocPoll;
    @SQLScript(value="sql/doc/store/storeDelete")
    private PreparedStatement stmtDocDelete;
    @SQLScript(value="sql/doc/store/storePurge")
    private PreparedStatement stmtDocPurge;
    public static final int MAX_DOC_SIZE = 0x1000000;

    public MysqlStatDataProvider(DbPlatform platform, DatabaseConfiguration config) throws SQLException, ClassNotFoundException {
        super(platform, "sql", "com.mysql.jdbc.Driver", config);
        this.setConnectionUrl(String.format("jdbc:mysql://%s:%s/%s?allowMultiQueries=true", config.host, config.port, config.database));
        this.setTag("PREFIX", config.tablePrefix);
        if (config.username == null) {
            throw new BeardStatRuntimeException("config value stats.database.username must be provided.", null, false);
        }
        if (config.password == null) {
            throw new BeardStatRuntimeException("config value stats.database.password must be provided.", null, false);
        }
        this.connectionProperties.put("user", config.username);
        this.connectionProperties.put("password", config.password);
        this.connectionProperties.put("autoReconnect", "true");
        this.initialise();
    }

    @Override
    public boolean generateBackup(String file) {
        this.platform.getLogger().log(Level.INFO, "Creating backup of database at {0}", file);
        try {
            FileOutputStream fw = new FileOutputStream(new File(this.platform.getDataFolder(), file + ".sql.gz"));
            GZIPOutputStream gos = new GZIPOutputStream(fw){
                {
                    this.def.setLevel(9);
                }
            };
            this.dumpToBuffer(new BufferedWriter(new OutputStreamWriter(gos)));
            return true;
        }
        catch (IOException ex) {
            this.platform.getLogger().log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Override
    public boolean restoreBackup(String file) {
        return false;
    }

    private ResultSet query(String sql) throws SQLException {
        return this.connection.prepareStatement(sql).executeQuery();
    }

    private void dumpToBuffer(BufferedWriter buff) {
        try {
            String version = "-- If restoring to this backup, set stats.database.sql_db_version to : " + this.config.latestVersion;
            StringBuilder sb = new StringBuilder();
            ResultSet rs = this.query("SHOW FULL TABLES WHERE Table_type != 'VIEW'");
            while (rs.next()) {
                String tbl = rs.getString(1);
                if (!tbl.startsWith(this.getSQLTag("PREFIX"))) continue;
                sb.append(version).append("\n");
                sb.append("\n");
                sb.append("-- ----------------------------\n").append("-- Table structure for `").append(tbl).append("`\n-- ----------------------------\n");
                sb.append("DROP TABLE IF EXISTS `").append(tbl).append("`;\n");
                ResultSet rs2 = this.query("SHOW CREATE TABLE `" + tbl + "`");
                rs2.next();
                String crt = rs2.getString(2) + ";";
                sb.append(crt).append("\n");
                sb.append("\n");
                sb.append("-- ----------------------------\n").append("-- Records for `").append(tbl).append("`\n-- ----------------------------\n");
                ResultSet rss = this.query("SELECT * FROM " + tbl);
                while (rss.next()) {
                    int colCount = rss.getMetaData().getColumnCount();
                    if (colCount <= 0) continue;
                    sb.append("INSERT INTO ").append(tbl).append(" VALUES(");
                    for (int i = 0; i < colCount; ++i) {
                        if (i > 0) {
                            sb.append(",");
                        }
                        String s = "";
                        try {
                            s = s + "'";
                            s = s + rss.getObject(i + 1).toString();
                            s = s + "'";
                        }
                        catch (Exception e) {
                            s = "NULL";
                        }
                        sb.append(s);
                    }
                    sb.append(");\n");
                    buff.append(sb.toString());
                    sb = new StringBuilder();
                }
            }
            buff.flush();
            buff.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public DocumentFile pullDocument(int entityId, String domain, String key) {
        DocumentFile file = null;
        try {
            boolean acStatus = this.connection.getAutoCommit();
            ResultSet rs = this.getDocumentResultSet(entityId, domain, key);
            if (rs.next()) {
                int docId = this.getDocumentId(rs);
                String curRev = this.getCurrentRev(rs);
                rs.close();
                this.stmtDocSelect.setInt(1, docId);
                this.stmtDocSelect.setString(2, curRev);
                rs = this.stmtDocSelect.executeQuery();
                if (rs.next()) {
                    String parentRev = rs.getString("parentRev");
                    Timestamp added = rs.getTimestamp("added");
                    Blob document = rs.getBlob("document");
                    JsonReader jsr = new JsonReader(new InputStreamReader(document.getBinaryStream()));
                    this.platform.getLogger().fine(new String(document.getBytes(1L, (int)document.length())));
                    IStatDocument fromJson = (IStatDocument)DocumentRegistry.instance().fromJson(jsr, (Type)((Object)IStatDocument.class));
                    file = new DocumentFile(curRev, parentRev, domain, key, fromJson, added);
                }
                rs.close();
            } else {
                this.platform.getLogger().fine("No document entry found.");
                rs.close();
            }
            this.connection.setAutoCommit(acStatus);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentFile pushDocument(int entityId, DocumentFile document) throws IStatDataProvider.RevisionMismatchException, DocumentTooLargeException {
        DocumentFile returnDoc = null;
        try {
            boolean isSingleton = document.getDocument().getClass().getAnnotation(StatDocument.class).singleInstance();
            ResultSet rs = this.getDocumentResultSet(entityId, document.getDomain(), document.getKey());
            if (rs.next()) {
                byte[] docData;
                boolean isNull;
                int docId = this.getDocumentId(rs);
                String headRev = this.getCurrentRev(rs);
                rs.close();
                Object doc = document.getDocument();
                boolean bl = isNull = headRev == null && headRev == document.getRevision();
                if (!isNull && !headRev.equalsIgnoreCase(document.getRevision())) {
                    DocumentFile dbDoc = this.pullDocument(entityId, document.getDomain(), document.getKey());
                    doc = doc.mergeDocument(dbDoc);
                }
                if ((docData = DocumentRegistry.instance().toJson(document.getDocument(), DocumentRegistry.getSerializeAs(document.getDocument().getClass())).getBytes()).length > 0x1000000) {
                    throw new DocumentTooLargeException("Document exceeds max size.");
                }
                MessageDigest digest = MessageDigest.getInstance("SHA1");
                String newRevision = this.byteArrayToHexString(digest.digest(docData));
                this.stmtMetaUpdate.setString(1, newRevision);
                this.stmtMetaUpdate.setInt(2, docId);
                int updResult = this.stmtMetaUpdate.executeUpdate();
                if (updResult != 1) {
                    throw new SQLException("Update to doc meta table affected " + updResult + " rows instead of 1.");
                }
                this.stmtDocInsert.setInt(1, docId);
                this.stmtDocInsert.setString(2, newRevision);
                this.stmtDocInsert.setString(3, isSingleton ? null : headRev);
                Timestamp tStamp = new Timestamp(System.currentTimeMillis());
                this.stmtDocInsert.setTimestamp(4, tStamp);
                this.stmtDocInsert.setBlob(5, new ByteArrayInputStream(docData));
                this.stmtDocInsert.executeUpdate();
                rs = this.stmtDocInsert.getGeneratedKeys();
                rs.next();
                rs.close();
                returnDoc = new DocumentFile(newRevision, headRev, document.getDomain(), document.getKey(), (IStatDocument)document.getDocument(), tStamp);
                if (isSingleton && document.getRevision() != null) {
                    this.deleteDocumentRevision(entityId, document.getDomain(), document.getKey(), document.getRevision());
                }
            } else {
                rs.close();
                byte[] doc = DocumentRegistry.instance().toJson(document.getDocument(), DocumentRegistry.getSerializeAs(document.getDocument().getClass())).getBytes();
                if (doc.length > 0x1000000) {
                    throw new RuntimeException("Document exceeds max size.");
                }
                MessageDigest digest = MessageDigest.getInstance("SHA1");
                String newRevision = this.byteArrayToHexString(digest.digest(doc));
                this.stmtMetaInsert.setInt(1, entityId);
                this.stmtMetaInsert.setInt(2, this.getDomain(document.getDomain(), true).getDbId());
                this.stmtMetaInsert.setString(3, document.getKey());
                this.stmtMetaInsert.setString(4, newRevision);
                this.stmtMetaInsert.executeUpdate();
                rs = this.stmtMetaInsert.getGeneratedKeys();
                rs.next();
                int docId = rs.getInt(1);
                rs.close();
                this.stmtDocInsert.setInt(1, docId);
                this.stmtDocInsert.setString(2, newRevision);
                this.stmtDocInsert.setNull(3, 1);
                Timestamp tStamp = new Timestamp(System.currentTimeMillis());
                this.stmtDocInsert.setTimestamp(4, tStamp);
                this.stmtDocInsert.setBlob(5, new ByteArrayInputStream(doc));
                this.stmtDocInsert.execute();
                returnDoc = new DocumentFile(newRevision, null, document.getDomain(), document.getKey(), (IStatDocument)document.getDocument(), tStamp);
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            try {
                this.platform.mysqlError(e, "push doc");
                this.connection.rollback();
            }
            catch (SQLException ex) {
                Logger.getLogger(MysqlStatDataProvider.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(MysqlStatDataProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                this.connection.setAutoCommit(true);
            }
            catch (SQLException ex) {
                Logger.getLogger(MysqlStatDataProvider.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        returnDoc.setOwner(document.getOwner());
        return returnDoc;
    }

    @Override
    public String[] getDocumentKeysInDomain(int entityId, String domain) {
        try {
            this.stmtMetaPoll.setInt(1, entityId);
            this.stmtMetaPoll.setInt(2, this.getDomain(domain, true).getDbId());
            ResultSet rs = this.stmtMetaPoll.executeQuery();
            ArrayList<String> keys = new ArrayList<String>();
            while (rs.next()) {
                keys.add(rs.getString("key"));
            }
            rs.close();
            return keys.toArray(new String[0]);
        }
        catch (SQLException ex) {
            Logger.getLogger(MysqlStatDataProvider.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public DocumentHistory getDocumentHistory(int entityId, String domain, String key) {
        try {
            ResultSet rs = this.getDocumentResultSet(entityId, domain, key);
            if (rs.next()) {
                int docId = this.getDocumentId(rs);
                String headRev = this.getCurrentRev(rs);
                rs.close();
                this.stmtDocPoll.setInt(1, docId);
                rs = this.stmtDocPoll.executeQuery();
                DocumentHistory history = new DocumentHistory(domain, key, headRev);
                while (rs.next()) {
                    history.addEntry(rs.getString("revision"), rs.getString("parentRev"), rs.getTimestamp("added"));
                }
                rs.close();
                return history;
            }
        }
        catch (SQLException e) {
            this.platform.mysqlError(e, SQL_DOC_STORE_POLL);
        }
        return null;
    }

    @Override
    public void deleteDocumentRevision(int entityId, String domain, String key, String revision) {
        if (revision == null) {
            throw new IllegalArgumentException("Cannot have null revision");
        }
        try {
            ResultSet rs = this.getDocumentResultSet(entityId, domain, key);
            int docId = -1;
            if (!rs.next()) {
                return;
            }
            docId = this.getDocumentId(rs);
            rs.close();
            DocumentHistory history = this.getDocumentHistory(entityId, domain, key);
            boolean isHead = history.getHeadRevision().equals(revision);
            String newHeadRev = history.getEntry(revision).getParentRev();
            this.stmtDocDelete.setInt(1, docId);
            this.stmtDocDelete.setString(2, revision);
            this.stmtDocDelete.execute();
            if (isHead) {
                this.stmtMetaUpdate.setString(1, newHeadRev);
                this.stmtMetaUpdate.setInt(2, docId);
                this.stmtMetaUpdate.executeUpdate();
            }
            if (this.getDocumentHistory(entityId, domain, key).getEntries().size() == 0) {
                this.stmtMetaDelete.setInt(1, docId);
                this.stmtMetaDelete.execute();
            }
        }
        catch (SQLException e) {
            this.platform.mysqlError(e, "Delete document");
        }
    }

    private ResultSet getDocumentResultSet(int entityId, String domain, String key) throws SQLException {
        this.connection.setTransactionIsolation(8);
        this.connection.setAutoCommit(false);
        int domainId = this.getDomain(domain, true).getDbId();
        this.stmtMetaSelect.setInt(1, entityId);
        this.stmtMetaSelect.setInt(2, domainId);
        this.stmtMetaSelect.setString(3, key);
        this.platform.getLogger().log(Level.FINE, "eid: {0}, domainId: {1}, key: {2}", new Object[]{entityId, domainId, key});
        return this.stmtMetaSelect.executeQuery();
    }

    private String getCurrentRev(ResultSet rs) throws SQLException {
        return rs.getString("curRevision");
    }

    private int getDocumentId(ResultSet rs) throws SQLException {
        return rs.getInt("documentId");
    }

    @Override
    public void deleteDocument(int entityId, String domain, String key) {
        try {
            ResultSet rs = this.getDocumentResultSet(entityId, domain, key);
            if (rs.next()) {
                int docId = this.getDocumentId(rs);
                rs.close();
                this.stmtDocPurge.setInt(1, docId);
                this.stmtDocPurge.execute();
                if (this.getDocumentHistory(entityId, domain, key).getEntries().size() == 0) {
                    this.stmtMetaDelete.setInt(1, docId);
                    this.stmtMetaDelete.execute();
                }
            }
        }
        catch (SQLException e) {
            this.platform.mysqlError(e, "deleteDocument");
        }
    }
}

