/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.dataproviders;

import com.tehbeard.beardstat.containers.EntityStatBlob;
import com.tehbeard.beardstat.containers.documents.DocumentHistory;
import com.tehbeard.beardstat.containers.documents.docfile.DocumentFile;
import com.tehbeard.beardstat.dataproviders.DocumentTooLargeException;
import com.tehbeard.beardstat.dataproviders.ProviderQuery;
import com.tehbeard.beardstat.dataproviders.ProviderQueryResult;
import com.tehbeard.beardstat.dataproviders.metadata.CategoryMeta;
import com.tehbeard.beardstat.dataproviders.metadata.DomainMeta;
import com.tehbeard.beardstat.dataproviders.metadata.StatisticMeta;
import com.tehbeard.beardstat.dataproviders.metadata.WorldMeta;

public interface IStatDataProvider {
    public static final String PLAYER_TYPE = "player";
    public static final String GROUP_TYPE = "group";
    public static final String FACTION_TYPE = "faction";
    public static final String ALLIANCE_TYPE = "alliance";
    public static final String WORLD_TYPE = "world";
    public static final String PLUGIN_TYPE = "plugin";

    public EntityStatBlob pullEntityBlob(ProviderQuery var1);

    public void pushEntityBlob(EntityStatBlob var1);

    public boolean hasEntityBlob(ProviderQuery var1);

    public boolean deleteEntityBlob(EntityStatBlob var1);

    public ProviderQueryResult[] queryDatabase(ProviderQuery var1);

    public void flushSync();

    public void flush();

    public DomainMeta getDomain(String var1, boolean var2);

    public WorldMeta getWorld(String var1, boolean var2);

    public CategoryMeta getCategory(String var1, boolean var2);

    public StatisticMeta getStatistic(String var1, boolean var2);

    public DocumentFile pullDocument(int var1, String var2, String var3);

    public DocumentFile pushDocument(int var1, DocumentFile var2) throws RevisionMismatchException, DocumentTooLargeException;

    public void deleteDocumentRevision(int var1, String var2, String var3, String var4);

    public void deleteDocument(int var1, String var2, String var3);

    public String[] getDocumentKeysInDomain(int var1, String var2);

    public DocumentHistory getDocumentHistory(int var1, String var2, String var3);

    public boolean generateBackup(String var1);

    public boolean restoreBackup(String var1);

    public void setUUID(String var1, String var2);

    public static class RevisionMismatchException
    extends Exception {
        private static final long serialVersionUID = 467302713446315251L;
        private final DocumentFile newFile;

        public DocumentFile getNewFile() {
            return this.newFile;
        }

        public RevisionMismatchException(DocumentFile newFile) {
            this.newFile = newFile;
        }
    }
}

