/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.bukkit.utils;

import com.tehbeard.beardstat.bukkit.identifier.HomebrewIdentifierGenerator;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.material.Coal;
import org.bukkit.material.Dye;
import org.bukkit.material.FlowerPot;
import org.bukkit.material.Leaves;
import org.bukkit.material.LongGrass;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Sandstone;
import org.bukkit.material.SmoothBrick;
import org.bukkit.material.Step;
import org.bukkit.material.Tree;
import org.bukkit.material.WoodenStep;
import org.bukkit.material.Wool;
import org.bukkit.potion.PotionType;

public class BukkitHumanNameGenerator {
    private static Map<Class<? extends MaterialData>, String> readers = new HashMap<Class<? extends MaterialData>, String>();
    private static Map<String, String> mapping = new HashMap<String, String>();

    public static String map(String key) {
        return mapping.containsKey(key) ? mapping.get(key) : key;
    }

    public static void init() {
        BukkitHumanNameGenerator.genForEnum((Enum[])EntityRegainHealthEvent.RegainReason.values());
        BukkitHumanNameGenerator.genForEnum((Enum[])EntityDamageEvent.DamageCause.values());
        BukkitHumanNameGenerator.genForEnum((Enum[])Material.values());
        BukkitHumanNameGenerator.genForEnum((Enum[])PotionType.values());
        BukkitHumanNameGenerator.genForEnum((Enum[])EntityType.values());
        BukkitHumanNameGenerator.genMetadataMaterial();
    }

    private static void genForEnum(Enum[] _enum) {
        for (Enum e : _enum) {
            mapping.put(e.toString().toLowerCase().replace("_", ""), e.toString().toLowerCase().replace("_", " "));
        }
    }

    private static void genMetadataMaterial() {
        for (Map.Entry<Material, HomebrewIdentifierGenerator.EntryInfo> e : HomebrewIdentifierGenerator.mats.entrySet()) {
            Material m = e.getKey();
            String base = m.toString().toLowerCase().replaceAll("_", "");
            String baseName = m.toString().toLowerCase().replaceAll("_", " ");
            HomebrewIdentifierGenerator.EntryInfo info = e.getValue();
            for (int i = info.min; i <= info.max; ++i) {
                int val = info.getMetdataValue(i);
                String prefix = BukkitHumanNameGenerator.getDataBasedPrefix(m, (byte)val);
                mapping.put(base + "_" + val, prefix + baseName);
            }
        }
    }

    private static String getDataBasedPrefix(Material m, byte data) {
        MaterialData md = m.getNewData(data);
        try {
            Method method = md.getClass().getMethod(readers.get(md.getClass()), new Class[0]);
            if (method == null) {
                return "";
            }
            Object o = method.invoke((Object)md, new Object[0]);
            if (o instanceof MaterialData) {
                return ((MaterialData)o).getItemType().toString().toLowerCase() + " ";
            }
            return o.toString().toLowerCase() + " ";
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            return "";
        }
        return "";
    }

    public static void main(String[] args) throws FileNotFoundException {
        HomebrewIdentifierGenerator.readData(new FileInputStream("src/main/resources/metadata.txt"));
        BukkitHumanNameGenerator.init();
        System.out.println("=nullfix script=");
        for (Map.Entry<String, String> e : mapping.entrySet()) {
            BukkitHumanNameGenerator.p("UPDATE ${PREFIX}_statistic SET `name`='" + e.getValue() + "' WHERE `statistic`='" + e.getKey() + "' and `name` IS NULL;");
        }
        System.out.println("=statistic.sql=");
        BukkitHumanNameGenerator.p("INSERT IGNORE INTO ${PREFIX}_domain (domain) VALUES ('default');");
        BukkitHumanNameGenerator.p("INSERT IGNORE INTO ${PREFIX}_world (world,name) VALUES ('__global__','Global');");
        for (Map.Entry<String, String> e : mapping.entrySet()) {
            BukkitHumanNameGenerator.p("INSERT IGNORE INTO ${PREFIX}_statistic (`name`,`statistic`) VALUES('" + e.getValue() + "','" + e.getKey() + "');");
        }
        System.out.println("=statistic.sqlite=");
        BukkitHumanNameGenerator.p("INSERT OR IGNORE INTO ${PREFIX}_domain (domain) VALUES ('default');");
        BukkitHumanNameGenerator.p("INSERT OR IGNORE INTO ${PREFIX}_world (world,name) VALUES ('__global__','Global');");
        for (Map.Entry<String, String> e : mapping.entrySet()) {
            BukkitHumanNameGenerator.p("INSERT OR INGORE INTO ${PREFIX}_statistic (`name`,`statistic`) VALUES('" + e.getValue() + "','" + e.getKey() + "');");
        }
    }

    private static void p(String l) {
        System.out.println(l);
    }

    static {
        readers.put(Dye.class, "getColor");
        readers.put(Wool.class, "getColor");
        readers.put(Leaves.class, "getSpecies");
        readers.put(Tree.class, "getSpecies");
        readers.put(WoodenStep.class, "getSpecies");
        readers.put(LongGrass.class, "getSpecies");
        readers.put(Step.class, "getMaterial");
        readers.put(SmoothBrick.class, "getMaterial");
        readers.put(Sandstone.class, "getType");
        readers.put(Coal.class, "getType");
        readers.put(FlowerPot.class, "getContents");
    }
}

