/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.bukkit.listeners;

import com.tehbeard.beardstat.bukkit.BukkitPlugin;
import com.tehbeard.beardstat.bukkit.listeners.StatListener;
import com.tehbeard.beardstat.bukkit.utils.StatUtils;
import com.tehbeard.beardstat.containers.EntityStatBlob;
import com.tehbeard.beardstat.manager.EntityStatManager;
import com.tehbeard.beardstat.manager.OnlineTimeManager;
import com.tehbeard.beardstat.utils.deferred.promise.Delegate;
import com.tehbeard.beardstat.utils.deferred.promise.Promise;
import java.util.Collection;
import java.util.Date;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffect;

public class StatPlayerListener
extends StatListener {
    public StatPlayerListener(EntityStatManager playerStatManager, BukkitPlugin plugin) {
        super(playerStatManager, plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerAnimation(PlayerAnimationEvent event) {
        if (event.isCancelled() || !this.shouldTrackPlayer(event.getPlayer(), "player_arm")) {
            return;
        }
        if (event.getAnimationType() == PlayerAnimationType.ARM_SWING) {
            StatUtils.instance.modifyStatPlayer(event.getPlayer(), "stats", "armswing", 1);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(final PlayerJoinEvent event) {
        StatUtils.instance.modifyStatPlayer(event.getPlayer(), "stats", "login", 1);
        StatUtils.instance.modifyStatPlayer(event.getPlayer(), "stats", "lastlogin", (int)(System.currentTimeMillis() / 1000L));
        this.getPlayerStatManager().getPlayer(event.getPlayer().getUniqueId(), event.getPlayer().getName()).onResolve(new Delegate<Void, Promise<EntityStatBlob>>(){

            @Override
            public <P extends Promise<EntityStatBlob>> Void invoke(P params) {
                if (!params.getValue().hasStat("default", "__global__", "stats", "firstlogin")) {
                    params.getValue().getStat("default", "__global__", "stats", "firstlogin").setValue((int)(event.getPlayer().getFirstPlayed() / 1000L));
                }
                return null;
            }
        });
        OnlineTimeManager.setRecord(event.getPlayer().getName(), event.getPlayer().getWorld().getName());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!event.isCancelled()) {
            int len = event.getMessage().length();
            StatUtils.instance.modifyStatPlayer(event.getPlayer(), "stats", "chatletters", len);
            StatUtils.instance.modifyStatPlayer(event.getPlayer(), "stats", "chat", 1);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (event.isCancelled() || !this.shouldTrackPlayer(event.getPlayer(), "item_drop")) {
            return;
        }
        StatUtils.instance.modifyStatItem(event.getPlayer(), "itemdrop", event.getItemDrop().getItemStack(), event.getItemDrop().getItemStack().getAmount());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerFish(PlayerFishEvent event) {
        if (event.isCancelled() || !this.shouldTrackPlayer(event.getPlayer(), "player_fish")) {
            return;
        }
        switch (event.getState()) {
            case CAUGHT_FISH: {
                StatUtils.instance.modifyStatPlayer(event.getPlayer(), "stats", "fishcaught", 1);
                if (!(event.getCaught() instanceof Item)) break;
                Item item = (Item)event.getCaught();
                item.getItemStack();
                StatUtils.instance.modifyStatItem(event.getPlayer(), "fishing", item.getItemStack(), item.getItemStack().getAmount());
                break;
            }
            case CAUGHT_ENTITY: {
                if (event.getCaught() instanceof Item) break;
                StatUtils.instance.modifyStatEntity(event.getPlayer(), "fishing", event.getCaught(), 1);
                break;
            }
            case FAILED_ATTEMPT: {
                break;
            }
            case FISHING: {
                break;
            }
            case IN_GROUND: {
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerKick(PlayerKickEvent event) {
        if (!event.isCancelled()) {
            StatUtils.instance.modifyStatPlayer(event.getPlayer(), "stats", "kicks", 1);
            StatUtils.instance.modifyStatPlayer(event.getPlayer(), "stats", "lastlogout", (int)(new Date().getTime() / 1000L));
            this.addTimeOnlineAndWipe(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        StatUtils.instance.modifyStatPlayer(event.getPlayer(), "stats", "lastlogout", (int)(new Date().getTime() / 1000L));
        this.addTimeOnlineAndWipe(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.isCancelled() || !this.shouldTrackPlayer(event.getPlayer(), "player_move")) {
            return;
        }
        if (event.getTo().getBlockX() != event.getFrom().getBlockX() || event.getTo().getBlockY() != event.getFrom().getBlockY() || event.getTo().getBlockZ() != event.getFrom().getBlockZ()) {
            double distance;
            Location from = event.getFrom();
            Location to = event.getTo();
            if (from.getWorld().equals(to.getWorld()) && (distance = from.distance(to)) < 8.0) {
                StatUtils.instance.modifyStatPlayer(event.getPlayer(), "stats", "move", (int)Math.ceil(distance));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        if (event.isCancelled() || !this.shouldTrackPlayer(event.getPlayer(), "item_pickup")) {
            return;
        }
        StatUtils.instance.modifyStatItem(event.getPlayer(), "itempickup", event.getItem().getItemStack(), event.getItem().getItemStack().getAmount());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerPortal(PlayerPortalEvent event) {
        if (!event.isCancelled()) {
            StatUtils.instance.modifyStatPlayer(event.getPlayer(), "stats", "portal", 1);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (!event.isCancelled()) {
            PlayerTeleportEvent.TeleportCause teleportCause = event.getCause();
            if (teleportCause == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
                StatUtils.instance.modifyStatPlayer(event.getPlayer(), "itemuse", "enderpearl", 1);
            }
            StatUtils.instance.modifyStatPlayer(event.getPlayer(), "stats", "teleport", 1);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        if (event.isCancelled() || !this.shouldTrackPlayer(event.getPlayer(), "player_bucket")) {
            return;
        }
        StatUtils.instance.modifyStatPlayer(event.getPlayer(), "stats", "fill" + event.getBucket().toString().toLowerCase().replace("_", ""), 1);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        if (event.isCancelled() || !this.shouldTrackPlayer(event.getPlayer(), "player_bucket")) {
            return;
        }
        StatUtils.instance.modifyStatPlayer(event.getPlayer(), "stats", "empty" + event.getBucket().toString().toLowerCase().replace("_", ""), 1);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (event.isCancelled() || !this.shouldTrackPlayer(event.getPlayer(), "entity_interact")) {
            return;
        }
        Material material = event.getPlayer().getItemInHand().getType();
        Entity rightClicked = event.getRightClicked();
        if (material == Material.BUCKET && rightClicked instanceof Cow) {
            StatUtils.instance.modifyStatPlayer(event.getPlayer(), "interact", "milkcow", 1);
            return;
        }
        if (material == Material.BOWL && rightClicked instanceof MushroomCow) {
            StatUtils.instance.modifyStatPlayer(event.getPlayer(), "interact", "milkmushroomcow", 1);
            return;
        }
        if (material == Material.INK_SACK && rightClicked instanceof Sheep) {
            StatUtils.instance.modifyStatPlayer(event.getPlayer(), "dye", "total", 1);
            StatUtils.instance.modifyStatItem(event.getPlayer(), "dye", event.getPlayer().getItemInHand(), 1);
            return;
        }
        if (material == Material.INK_SACK && rightClicked instanceof Wolf) {
            Wolf wolf = (Wolf)rightClicked;
            if (!wolf.isTamed()) {
                return;
            }
            if (wolf.getOwner() != event.getPlayer()) {
                return;
            }
            StatUtils.instance.modifyStatPlayer(event.getPlayer(), "wolfdye", "total", 1);
            StatUtils.instance.modifyStatItem(event.getPlayer(), "wolfdye", event.getPlayer().getItemInHand(), 1);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void shearEvent(PlayerShearEntityEvent event) {
        if (event.isCancelled() || !this.shouldTrackPlayer(event.getPlayer(), "entity_shear")) {
            return;
        }
        if (event.getEntity() instanceof Sheep) {
            StatUtils.instance.modifyStatPlayer(event.getPlayer(), "sheared", "sheep", 1);
        }
        if (event.getEntity() instanceof MushroomCow) {
            StatUtils.instance.modifyStatPlayer(event.getPlayer(), "sheared", "mushroomcow", 1);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.isCancelled() || !this.shouldTrackPlayer(event.getPlayer(), "player_use")) {
            return;
        }
        Action action = event.getAction();
        ItemStack item = event.getItem();
        Block clickedBlock = event.getClickedBlock();
        Event.Result result = event.useItemInHand();
        if (item != null && action != null && clickedBlock != null) {
            if (!(result.equals((Object)Event.Result.DENY) || item.getType() != Material.FLINT_AND_STEEL && item.getType() != Material.FIREBALL && item.getType() != Material.SIGN)) {
                StatUtils.instance.modifyStatItem(event.getPlayer(), "itemuse", item, 1);
            }
            if (clickedBlock.getType() == Material.CAKE_BLOCK || clickedBlock.getType() == Material.TNT && item.getType() == Material.FLINT_AND_STEEL) {
                StatUtils.instance.modifyStatBlock(event.getPlayer(), "itemuse", clickedBlock, 1);
            }
            if (clickedBlock.getType().equals((Object)Material.CHEST)) {
                StatUtils.instance.modifyStatPlayer(event.getPlayer(), "stats", "openchest", 1);
            }
            if (clickedBlock.getType().equals((Object)Material.FLOWER_POT) && action == Action.RIGHT_CLICK_BLOCK && clickedBlock.getData() == 0) {
                Material[] m;
                for (Material mm : m = new Material[]{Material.RED_ROSE, Material.YELLOW_FLOWER, Material.SAPLING, Material.RED_MUSHROOM, Material.BROWN_MUSHROOM, Material.CACTUS, Material.DEAD_BUSH}) {
                    if (!mm.equals((Object)item.getType())) continue;
                    StatUtils.instance.modifyStatItem(event.getPlayer(), "plant", item, 1);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerExp(PlayerExpChangeEvent event) {
        if (!this.shouldTrackPlayer(event.getPlayer(), "player_exp")) {
            return;
        }
        StatUtils.instance.modifyStatPlayer(event.getPlayer(), "exp", "lifetimexp", event.getAmount());
        StatUtils.instance.setPlayerStat(event.getPlayer(), "exp", "currentexp", event.getPlayer().getTotalExperience() + event.getAmount());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerExpLevel(PlayerLevelChangeEvent event) {
        if (!this.shouldTrackPlayer(event.getPlayer(), "player_exp")) {
            return;
        }
        StatUtils.instance.setPlayerStat(event.getPlayer(), "exp", "currentlvl", event.getNewLevel());
        int change = event.getNewLevel() - event.getOldLevel();
        if (change > 0) {
            StatUtils.instance.modifyStatPlayer(event.getPlayer(), "exp", "lifetimelvl", change);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEnchant(EnchantItemEvent event) {
        Player player = event.getEnchanter();
        if (event.isCancelled() || !this.shouldTrackPlayer(event.getEnchanter(), "player_exp")) {
            return;
        }
        if (!event.isCancelled()) {
            StatUtils.instance.modifyStatPlayer(player, "enchant", "total", 1);
            StatUtils.instance.modifyStatPlayer(player, "enchant", "totallvlspent", event.getExpLevelCost());
        }
    }

    private void addTimeOnlineAndWipe(Player player) {
        OnlineTimeManager.ManagerRecord timeRecord = OnlineTimeManager.getRecord(player.getName());
        if (timeRecord == null) {
            return;
        }
        if (timeRecord.world == null) {
            return;
        }
        StatUtils.instance.increment(player, timeRecord.world, "stats", "playedfor", timeRecord.sessionTime());
        OnlineTimeManager.wipeRecord(player.getName());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void worldJump(PlayerChangedWorldEvent event) {
        if (this.shouldTrackPlayer(event.getPlayer(), "player_time")) {
            this.addTimeOnlineAndWipe(event.getPlayer());
        }
        OnlineTimeManager.setRecord(event.getPlayer().getName(), event.getPlayer().getWorld().getName());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onNom(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        if (event.isCancelled() || !this.shouldTrackPlayer(event.getPlayer(), "player_consume")) {
            return;
        }
        if (event.getItem().getType().isEdible()) {
            StatUtils.instance.modifyStatItem(player, "consume", event.getItem(), 1);
            return;
        }
        if (event.getItem().getType() == Material.POTION) {
            PotionMeta meta = (PotionMeta)event.getItem().getItemMeta();
            if (meta != null) {
                for (PotionEffect effect : meta.getCustomEffects()) {
                    StatUtils.instance.modifyStatPotion(player, "consume", effect, 1);
                }
                return;
            }
            Collection potion = Potion.getBrewer().getEffectsFromDamage((int)event.getItem().getDurability());
            for (PotionEffect effect : potion) {
                StatUtils.instance.modifyStatPotion(player, "consume", effect, 1);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onLeash(PlayerLeashEntityEvent event) {
        if (event.isCancelled() || !this.shouldTrackPlayer(event.getPlayer(), "entity_interact")) {
            return;
        }
        Player player = event.getPlayer();
        StatUtils.instance.modifyStatEntity(player, "leash", event.getEntity(), 1);
    }
}

