/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.bukkit.listeners;

import com.tehbeard.beardstat.bukkit.BukkitPlugin;
import com.tehbeard.beardstat.bukkit.listeners.StatListener;
import com.tehbeard.beardstat.bukkit.utils.StatUtils;
import com.tehbeard.beardstat.manager.EntityStatManager;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;

public class StatEntityListener
extends StatListener {
    private final String[] DAMAGELBLS = new String[]{"damagedealt", "damagetaken"};
    private final String[] KDLBLS = new String[]{"kills", "deaths"};

    public StatEntityListener(EntityStatManager playerStatManager, BukkitPlugin plugin) {
        super(playerStatManager, plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.processEntityDamage(event, this.DAMAGELBLS, false);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityDeath(EntityDeathEvent event) {
        EntityDamageEvent lastCause = event.getEntity().getLastDamageCause();
        if (lastCause != null) {
            this.processEntityDamage(lastCause, this.KDLBLS, true);
        }
    }

    private void processEntityDamage(EntityDamageEvent event, String[] category, boolean forceOne) {
        int idx;
        Player player;
        Entity attacked = event.getEntity();
        EntityDamageEvent.DamageCause cause = event.getCause();
        int amount = forceOne ? 1 : (int)Math.floor(event.getDamage());
        Entity attacker = null;
        Projectile projectile = null;
        boolean dispenserFired = false;
        if (event instanceof EntityDamageByEntityEvent) {
            attacker = ((EntityDamageByEntityEvent)event).getDamager();
        }
        if (attacker instanceof Projectile) {
            projectile = (Projectile)attacker;
            ProjectileSource projectileSource = projectile.getShooter();
            if (projectileSource instanceof Entity) {
                attacker = (Entity)projectileSource;
            }
            if (projectileSource instanceof BlockProjectileSource) {
                dispenserFired = true;
            }
        }
        if (attacker instanceof ComplexEntityPart) {
            attacker = ((ComplexEntityPart)attacker).getParent();
        }
        if (attacked instanceof ComplexEntityPart) {
            attacked = ((ComplexEntityPart)attacked).getParent();
        }
        Object object = attacked instanceof Player ? (Player)attacked : (player = attacker instanceof Player ? (Player)attacker : null);
        Entity other = attacked instanceof Player ? attacker : (attacker instanceof Player ? attacked : null);
        int n = idx = attacker instanceof Player ? 0 : 1;
        if (player == null) {
            return;
        }
        if (event.isCancelled() || !this.shouldTrackPlayer(player, "entity_" + category[idx])) {
            return;
        }
        StatUtils.instance.modifyStatPlayer(player, category[idx], "total", amount);
        if (cause != EntityDamageEvent.DamageCause.PROJECTILE) {
            StatUtils.instance.modifyStatPlayer(player, category[idx], cause.toString().toLowerCase().replace("_", ""), amount);
        }
        if (other != null && !(other instanceof Player)) {
            StatUtils.instance.modifyStatEntity(player, category[idx], other, amount);
        }
        if (projectile != null) {
            StatUtils.instance.modifyStatEntity(player, category[idx], (Entity)projectile, amount);
        }
        if (dispenserFired) {
            StatUtils.instance.modifyStatPlayer(player, category[idx], "dispenser", amount);
        }
        if (attacker instanceof Player && attacked instanceof Player) {
            StatUtils.instance.modifyStatPlayer((Player)attacker, category[0], "pvp", 1);
            StatUtils.instance.modifyStatPlayer((Player)attacked, category[1], "pvp", 1);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityRegainHealth(EntityRegainHealthEvent event) {
        if (!event.isCancelled() && event.getEntity() instanceof Player) {
            int amount = (int)Math.floor(event.getAmount());
            EntityRegainHealthEvent.RegainReason reason = event.getRegainReason();
            Player player = (Player)event.getEntity();
            if (!this.shouldTrackPlayer(player, "entity_heal")) {
                return;
            }
            StatUtils.instance.modifyStatPlayer(player, "stats", "damagehealed", amount);
            if (reason != EntityRegainHealthEvent.RegainReason.CUSTOM) {
                StatUtils.instance.modifyStatPlayer(player, "stats", "heal" + reason.toString().replace("_", "").toLowerCase(), amount);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityTame(EntityTameEvent event) {
        if (!event.isCancelled() && event.getOwner() instanceof Player) {
            if (event.isCancelled() || !this.shouldTrackPlayer((Player)event.getOwner(), "entity_tame")) {
                return;
            }
            StatUtils.instance.modifyStatEntity((Player)event.getOwner(), "tame", (Entity)event.getEntity(), 1);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPotionSplash(PotionSplashEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ThrownPotion potion = event.getPotion();
        for (Entity e : event.getAffectedEntities()) {
            Player p;
            if (!(e instanceof Player) || !this.shouldTrackPlayer(p = (Player)e, "entity_potion")) continue;
            StatUtils.instance.modifyStatPlayer(p, "potions", "splashhit", 1);
            for (PotionEffect potionEffect : potion.getEffects()) {
                StatUtils.instance.modifyStatPotion(p, "potions", potionEffect, 1);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBowShoot(EntityShootBowEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (!this.shouldTrackPlayer(player, "entity_bow")) {
                return;
            }
            StatUtils.instance.modifyStatPlayer(player, "bow", "shots", 1);
            if (event.getBow().containsEnchantment(Enchantment.ARROW_FIRE)) {
                StatUtils.instance.modifyStatPlayer(player, "bow", "fireshots", 1);
            }
            if (event.getBow().containsEnchantment(Enchantment.ARROW_INFINITE)) {
                StatUtils.instance.modifyStatPlayer(player, "bow", "infiniteshots", 1);
            }
        }
    }
}

