/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.bukkit;

import com.tehbeard.beardstat.bukkit.cfg.YamlConfigInjector;
import com.tehbeard.beardstat.cfg.InjectConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.GameMode;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class WorldManager {
    private WorldData defaultWorld = new WorldData(true, false, false);
    Map<String, WorldData> worlds = new HashMap<String, WorldData>();

    public WorldManager() {
    }

    public WorldManager(ConfigurationSection section) {
        if (section != null) {
            Set keys = section.getKeys(false);
            for (String key : keys) {
                WorldData d = new WorldData();
                new YamlConfigInjector(section.getConfigurationSection(key)).inject(d);
                this.worlds.put(key, d);
                if (!key.equalsIgnoreCase("default")) continue;
                this.defaultWorld = d;
            }
        }
    }

    public boolean shouldTrack(Player player, String trackType) {
        if (this.worlds.containsKey(player.getWorld().getName())) {
            return this.worlds.get(player.getWorld().getName()).shouldTrack(player, trackType);
        }
        return this.defaultWorld.shouldTrack(player, trackType);
    }

    public void addWorld(String name, boolean s, boolean c, boolean a) {
        this.worlds.put(name, new WorldData(s, c, a));
    }

    private static class WorldData {
        @InjectConfig(value="survival")
        private boolean survival;
        @InjectConfig(value="creative")
        private boolean creative;
        @InjectConfig(value="adventure")
        private boolean adventure;
        @InjectConfig(value="blacklist")
        private List<String> blacklist = new ArrayList<String>();
        @InjectConfig(value="whitelist")
        private List<String> whitelist = new ArrayList<String>();

        public WorldData() {
            this.survival = true;
            this.creative = false;
            this.adventure = false;
        }

        private WorldData(boolean s, boolean c, boolean a) {
            this.survival = s;
            this.creative = c;
            this.adventure = a;
        }

        public boolean shouldTrack(Player player, String trackType) {
            GameMode gm = player.getGameMode();
            return (gm == GameMode.SURVIVAL && this.survival || gm == GameMode.CREATIVE && this.creative || gm == GameMode.ADVENTURE && this.adventure) && this.trackType(trackType);
        }

        public boolean trackType(String type) {
            if (this.blacklist.size() > 0 && this.blacklist.contains(type)) {
                return false;
            }
            return this.whitelist.size() <= 0 || this.whitelist.contains(type);
        }
    }
}

