/*
 * Decompiled with CFR 0.152.
 */
package com.tehbeard.beardstat.bukkit;

import com.tehbeard.beardstat.BeardStatRuntimeException;
import com.tehbeard.beardstat.DatabaseConfiguration;
import com.tehbeard.beardstat.DbPlatform;
import com.tehbeard.beardstat.LanguagePack;
import com.tehbeard.beardstat.ProfileUUIDUpdater;
import com.tehbeard.beardstat.StatConfiguration;
import com.tehbeard.beardstat.bukkit.EntityStatBlobLoadEvent;
import com.tehbeard.beardstat.bukkit.WorldManager;
import com.tehbeard.beardstat.bukkit.cfg.YamlConfigInjector;
import com.tehbeard.beardstat.bukkit.commands.Commands;
import com.tehbeard.beardstat.bukkit.commands.LastOnCommand;
import com.tehbeard.beardstat.bukkit.commands.StatCommand;
import com.tehbeard.beardstat.bukkit.commands.StatPageCommand;
import com.tehbeard.beardstat.bukkit.commands.StatScriptExecCommand;
import com.tehbeard.beardstat.bukkit.commands.playedCommand;
import com.tehbeard.beardstat.bukkit.identifier.HomebrewIdentifierGenerator;
import com.tehbeard.beardstat.bukkit.identifier.IdentifierService;
import com.tehbeard.beardstat.bukkit.listeners.StatBlockListener;
import com.tehbeard.beardstat.bukkit.listeners.StatCraftListener;
import com.tehbeard.beardstat.bukkit.listeners.StatEntityListener;
import com.tehbeard.beardstat.bukkit.listeners.StatPlayerListener;
import com.tehbeard.beardstat.bukkit.listeners.StatVehicleListener;
import com.tehbeard.beardstat.bukkit.utils.BukkitHumanNameGenerator;
import com.tehbeard.beardstat.bukkit.utils.StatUtils;
import com.tehbeard.beardstat.containers.EntityStatBlob;
import com.tehbeard.beardstat.dataproviders.IStatDataProvider;
import com.tehbeard.beardstat.dataproviders.JDBCStatDataProvider;
import com.tehbeard.beardstat.dataproviders.MysqlStatDataProvider;
import com.tehbeard.beardstat.dataproviders.SQLiteStatDataProvider;
import com.tehbeard.beardstat.manager.EntityStatManager;
import com.tehbeard.beardstat.manager.OnlineTimeManager;
import com.tehbeard.beardstat.utils.Metrics;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitPlugin
extends JavaPlugin
implements DbPlatform {
    private int saveTaskId;
    private EntityStatManager statManager;
    public static StatConfiguration configuration;
    public static WorldManager worldManager;

    public EntityStatManager getStatManager() {
        return this.statManager;
    }

    public void onDisable() {
        this.getLogger().info("Stopping auto flusher");
        this.getServer().getScheduler().cancelTask(this.saveTaskId);
        if (this.statManager != null) {
            this.getLogger().info("Flushing cache to database");
            this.statManager.saveCache();
            this.statManager.flush();
            this.getLogger().info("Cache flushed to database");
        }
    }

    public void onEnable() {
        this.getLogger().info("Starting BeardStat");
        HomebrewIdentifierGenerator.readData(this.getResource("metadata.txt"));
        try {
            HomebrewIdentifierGenerator.readData(new FileInputStream(new File(this.getDataFolder(), "metadata.txt")));
        }
        catch (FileNotFoundException e) {
            this.getLogger().warning("No External metadata file detected");
        }
        BukkitHumanNameGenerator.init();
        try {
            this.getLogger().info("Loading default language pack");
            LanguagePack.load(this.getResource("messages.lang"));
            File extLangPack = new File(this.getDataFolder(), "messages.lang");
            if (extLangPack.exists()) {
                this.getLogger().info("External language pack detected! Loading...");
                LanguagePack.overlay(new FileInputStream(extLangPack));
            }
        }
        catch (IOException e1) {
            this.getLogger().severe("Failed to load language pack.");
        }
        try {
            this.updateConfig();
            this.saveConfig();
            this.reloadConfig();
        }
        catch (Exception e) {
            this.handleError(new BeardStatRuntimeException("An error occured while loading or updating the config", e, false));
            return;
        }
        this.reloadConfig();
        this.getConfig();
        configuration = new StatConfiguration();
        new YamlConfigInjector((ConfigurationSection)this.getConfig()).inject(configuration);
        this.getLogger().config(configuration.toString());
        Level level = Level.parse(BukkitPlugin.configuration.logLevel);
        this.getLogger().setLevel(level);
        for (Handler handler : this.getLogger().getHandlers()) {
            handler.setLevel(level);
        }
        File worldsFile = new File(this.getDataFolder(), "worlds.yml");
        worldManager = new WorldManager(YamlConfiguration.loadConfiguration((File)worldsFile).getConfigurationSection("worlds"));
        this.getLogger().info("Connecting to database");
        this.getLogger().info("Using " + BukkitPlugin.configuration.dbType + " Adpater");
        DatabaseConfiguration dbConfig = this.getDatabaseConfiguration(this.getConfig().getConfigurationSection("stats.database"));
        IStatDataProvider db = this.getDataProvider(dbConfig);
        if (db == null) {
            this.getLogger().severe(" Error loading database, disabling plugin");
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        if (dbConfig.runUUIDUpdate) {
            try {
                new ProfileUUIDUpdater(this.getLogger(), db);
                this.getConfig().set("stats.database.uuidUpdate", (Object)false);
                this.saveConfig();
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to run UUID updater");
                e.printStackTrace();
            }
        }
        this.statManager = new EntityStatManager(this, db);
        this.getLogger().info("Loading id mapping");
        StatUtils.setManager(this.statManager);
        IdentifierService.setGenerator(new HomebrewIdentifierGenerator());
        this.getLogger().info("Registering events and collectors");
        try {
            StatBlockListener sbl = new StatBlockListener(this.statManager, this);
            StatPlayerListener spl = new StatPlayerListener(this.statManager, this);
            StatEntityListener sel = new StatEntityListener(this.statManager, this);
            StatVehicleListener svl = new StatVehicleListener(this.statManager, this);
            StatCraftListener scl = new StatCraftListener(this.statManager, this);
            this.getServer().getPluginManager().registerEvents((Listener)sbl, (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)spl, (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)sel, (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)svl, (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)scl, (Plugin)this);
        }
        catch (Exception e) {
            this.handleError(new BeardStatRuntimeException("Error registering events", e, false));
        }
        try {
            this.saveTaskId = this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new DbFlusher(), 2400L, 2400L);
        }
        catch (Exception e) {
            this.handleError(new BeardStatRuntimeException("Error starting database flusher", e, false));
        }
        this.getLogger().info("Loading commands");
        try {
            this.getCommand("stats").setExecutor((CommandExecutor)new StatCommand(this.statManager, this));
            this.getCommand("played").setExecutor((CommandExecutor)new playedCommand(this.statManager, this));
            this.getCommand("statpage").setExecutor((CommandExecutor)new StatPageCommand(this.statManager, this));
            this.getCommand("laston").setExecutor((CommandExecutor)new LastOnCommand(this.statManager, this));
            this.getCommand("statadmin").setExecutor((CommandExecutor)new Commands(this.statManager, this));
            this.getCommand("statexecscript").setExecutor((CommandExecutor)new StatScriptExecCommand(this.statManager, this, db instanceof JDBCStatDataProvider ? (JDBCStatDataProvider)db : null));
        }
        catch (Exception e) {
            this.handleError(new BeardStatRuntimeException("Error registering commands", e, false));
        }
        this.getLogger().info("loading any players already online");
        for (Player player : this.getServer().getOnlinePlayers()) {
            OnlineTimeManager.setRecord(player.getName(), player.getWorld().getName());
        }
        try {
            Metrics metrics = new Metrics((Plugin)this);
            metrics.createGraph("Database Type").addPlotter(new Metrics.Plotter(this.getConfig().getString("stats.database.type").toLowerCase()){

                @Override
                public int getValue() {
                    return 1;
                }
            });
            metrics.start();
        }
        catch (Exception e) {
            this.handleError(new BeardStatRuntimeException("Metrics threw an error during startup", null, true));
        }
        this.getLogger().info("BeardStat Loaded");
    }

    private void updateConfig() {
        this.saveResource("config.yml", false);
        this.saveResource("worlds.yml", false);
        if (this.getConfig().getInt("stats.configversion", 0) < this.getConfig().getDefaults().getInt("stats.configversion")) {
            this.getLogger().info("Updating config to include newest configuration options");
            this.getConfig().set("stats.configversion", null);
            this.getConfig().getDefaults().set("stats.database.sql_db_version", null);
            this.getConfig().options().copyDefaults(true);
        }
        if (this.getConfig().contains("stats.blacklist")) {
            try {
                this.getLogger().info("Moving blacklist to worlds.yml");
                File worldsFile = new File(this.getDataFolder(), "worlds.yml");
                YamlConfiguration worldCfg = YamlConfiguration.loadConfiguration((File)worldsFile);
                for (String world : this.getConfig().getStringList("stats.blacklist")) {
                    worldCfg.set("worlds." + world + ".survival", (Object)false);
                    worldCfg.set("worlds." + world + ".creative", (Object)false);
                    worldCfg.set("worlds." + world + ".adventure", (Object)false);
                }
                worldCfg.save(worldsFile);
            }
            catch (IOException ex) {
                Logger.getLogger(BukkitPlugin.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.getConfig().set("stats.blacklist", null);
        }
        this.saveConfig();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        sender.sendMessage("Command " + commandLabel + " not implemented!");
        return true;
    }

    @Override
    public boolean configValueIsSet(String key) {
        return this.getConfig().isSet(key);
    }

    @Override
    public void configValueSet(String key, Object val) {
        this.getConfig().set(key, val);
    }

    @Override
    public void loadEvent(EntityStatBlob esb) {
        Bukkit.getPluginManager().callEvent((Event)new EntityStatBlobLoadEvent(esb));
    }

    @Override
    public boolean isPlayerOnline(String player) {
        return Bukkit.getOfflinePlayer((String)player).isOnline();
    }

    @Override
    public String getWorldForPlayer(String entityName) {
        return Bukkit.getPlayer((String)entityName).getWorld().getName();
    }

    public static void sendNoPermissionError(CommandSender sender) {
        BukkitPlugin.sendNoPermissionError(sender, LanguagePack.getMsg("error.permission"));
    }

    public static void sendNoPermissionError(CommandSender sender, String message) {
        sender.sendMessage(ChatColor.RED + message);
    }

    @Override
    public void mysqlError(SQLException e, String script) {
        Logger logger = this.getLogger();
        logger.severe("=========================================");
        logger.severe("|             DATABASE ERROR            |");
        logger.severe("=========================================");
        logger.severe("");
        if (script != null) {
            logger.severe("Caused by script: " + script);
            logger.severe("");
        }
        logger.severe("Mysql error code: " + e.getErrorCode());
        switch (e.getErrorCode()) {
            case 1042: {
                logger.severe("Cannot find hostname provided, check spelling of hostname in config file");
                break;
            }
            case 1044: 
            case 1045: {
                logger.severe("Cannot connect to database, check user credentials, database exists and that user is able to log in from this machine");
                break;
            }
            case 1049: {
                logger.severe("Cannot locate database, check you spelt database name correctly and username has access rights from this machine.");
                break;
            }
            default: {
                logger.severe("Error code [" + e.getErrorCode() + "] not found (or not supplied!), either check the error code online, or post on the dev.bukkit.org/server-mods/beardstat page");
                logger.severe("Exception Detail:");
                logger.severe(e.getMessage());
            }
        }
        if (this.getConfig().getBoolean("general.verbose", false)) {
            logger.severe("=========================================");
            logger.severe("            Begin error dump             ");
            logger.severe("=========================================");
            e.printStackTrace();
            logger.severe("=========================================");
            logger.severe("             End error dump              ");
            logger.severe("=========================================");
        }
    }

    private IStatDataProvider getDataProvider(DatabaseConfiguration config) {
        JDBCStatDataProvider db = null;
        try {
            if (config.databaseType.equalsIgnoreCase("mysql")) {
                db = new MysqlStatDataProvider(this, config);
            }
            if (config.databaseType.equalsIgnoreCase("sqlite")) {
                db = new SQLiteStatDataProvider(this, new File(this.getDataFolder(), "stats.db").toString(), config);
            }
            if (config.databaseType.equalsIgnoreCase("memory")) {
                db = new SQLiteStatDataProvider(this, ":memory:", config);
            }
            if (config.databaseType.equalsIgnoreCase("file")) {
                this.getLogger().warning("FILE DRIVER NO LONGER SUPPORTED, PLEASE TRANSFER TO SQLITE/MYSQL IN PREVIOUS VERSION BEFORE LOADING");
            }
            if (config.databaseType.equalsIgnoreCase("transfer")) {
                throw new UnsupportedOperationException("NOT IMPLEMENTED YET");
            }
        }
        catch (BeardStatRuntimeException e) {
            this.handleError(e);
            db = null;
        }
        catch (SQLException e) {
            this.mysqlError(e, null);
            db = null;
        }
        catch (ClassNotFoundException ex) {
            this.handleError(ex);
            db = null;
        }
        return db;
    }

    @Override
    public void handleError(Exception e) {
        if (e instanceof BeardStatRuntimeException) {
            BeardStatRuntimeException be = (BeardStatRuntimeException)e;
            if (!be.isRecoverable()) {
                this.getLogger().severe("WARNING: BeardStat has encountered an error and cannot recover, disabling plugin.");
                this.getLogger().severe(be.getMessage());
                if (e != null) {
                    this.handleUnknownError(e);
                }
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
            } else {
                this.getLogger().severe("WARNING: BeardStat has encountered an error.");
                this.getLogger().severe(be.getMessage());
                if (e != null) {
                    this.handleUnknownError(e);
                }
            }
        } else {
            this.handleUnknownError(e);
        }
    }

    private void handleUnknownError(Exception e) {
        this.getLogger().severe("=========");
        this.getLogger().severe("BeardStat");
        this.getLogger().severe("=========");
        this.getLogger().severe("BeardStat encountered an error, please submit the following info + stack trace to the dev bukkit page (http://dev.bukkit.org/server-mods/BeardStat/");
        this.getLogger().severe("");
        this.getLogger().severe("BeardStat version: " + this.getDescription().getVersion());
        this.getLogger().severe("");
        e.printStackTrace();
        this.getLogger().severe("");
        this.getLogger().severe("=========");
    }

    public DatabaseConfiguration getDatabaseConfiguration(ConfigurationSection section) {
        DatabaseConfiguration dbc = new DatabaseConfiguration(this.getConfig().getDefaults().getInt("stats.database.sql_db_version"));
        new YamlConfigInjector(section).inject(dbc);
        return dbc;
    }

    public class DbFlusher
    implements Runnable {
        @Override
        public void run() {
            BukkitPlugin.this.getLogger().config("Flushing to database.");
            BukkitPlugin.this.statManager.saveCache();
            BukkitPlugin.this.statManager.flush();
            BukkitPlugin.this.getLogger().config("flush completed");
        }
    }
}

